<?php defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: Marketing Campaigns
Description: Define Marketing Campaigns
Version: 1.0.0
*/

define('MKC_MODULE_NAME', 'marketing_campaigns');
$CI = &get_instance();
hooks()->add_action('admin_init', 'mkc_register_permissions');
hooks()->add_action('admin_init', 'mkc_register_menu_items');


/**
 * Hook for assigning staff permissions for hr module
 *
 * @return void
 */
function mkc_register_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . '(' . _l('permission_global') . ')',
        'view_own'   => _l('permission_view_own'),
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities(MKC_MODULE_NAME, $capabilities, _l('marketing_campaigns'), _l('marketing_permissions'));
}


/**
 * Register new menu item in sidebar menu
 */
function mkc_register_menu_items()
{
    $CI = &get_instance();
  //  if (staff_can('view', MKC_MODULE_NAME) || staff_can('view_own', MKC_MODULE_NAME)) {



  //  }

    if (is_staff_member() && has_permission('marketing_campaigns', '', 'view')) {
        $CI->app_menu->add_sidebar_children_item('marketing', [
            'slug'     => 'mkc_manage',
            'name'     => _l('marketing_campaigns'),
            'href'     => admin_url('marketing_campaigns'),
            'position' => 3,
        ]);
    }
}



register_activation_hook(MKC_MODULE_NAME, 'mkc_activation_hook');
register_deactivation_hook(MKC_MODULE_NAME, 'mkc_deactivation_hook');
function mkc_activation_hook()
{

}
function mkc_deactivation_hook()
{

}

register_language_files(MKC_MODULE_NAME, ['marketing_campaigns']);
$CI->load->helper(MKC_MODULE_NAME . '/marketing_campaigns');
