<?php defined('BASEPATH') or exit('No direct script access allowed');
class Marketing_campaigns_model extends App_Model
{

  public $table_name = 'marketing_campaigns';

  /**
   * Create new holiday
   *
   * @param array $data
   *
   * @return int
   */
  public function add($data)
  {
    if (is_staff_logged_in()) {
      $data['addedfrom'] = get_staff_user_id();
    }


    $data['start'] = date('Y-m-d', strtotime($data['start']));
    $data['end']   = date('Y-m-d', strtotime($data['end']));

    $this->db->insert(db_prefix() . $this->table_name, $data);

    $id  = $this->db->insert_id();
    $log = 'ID: ' . $id;

    $isStaff = null;
    if (!is_client_logged_in() && is_staff_logged_in()) {
      $log     .= ', From Staff: ' . get_staff_user_id();
      $isStaff = get_staff_user_id();
    }

    log_activity('New Marketing Campaign Created [' . $log . ']', $isStaff);

    return $id;
  }

  /**
   * Update employye informations
   *
   * @param array data
   * @param integer ID
   *
   * @return boolean
   */
  public function update($data, $id)
  {
    $this->db->where('id', $id);

    $data['start'] = date('Y-m-d', strtotime($data['start']));
    $data['end']   = date('Y-m-d', strtotime($data['end']));

    $this->db->update(db_prefix() . $this->table_name, $data);

    if ($this->db->affected_rows() > 0) {

      log_activity('Marketing Campaign Updated [ID: ' . $id . ']');

      return true;
    }

    return false;
  }

  /**
   * Get holiday
   *
   * @param int|null $id
   *
   * @return array
   */
  public function get($id = null)
  {

    if(!$id){
      $this->getAll();
    }
    $this->db->where('id', (int)$id);
    return $this->db->get(db_prefix() . $this->table_name)->row();
  }

  public function getAll()
  {
    $this->db->order_by('start', 'desc');
    return $this->db->get(db_prefix() . $this->table_name)->result_array();
  }

  /**
   * Delete holiday
   *
   * @param int $id
   *
   * @return bool
   */
  public function delete($id)
  {
    $this->db->where('id', (int)$id);
    $this->db->delete(db_prefix() . $this->table_name);

    return $this->db->affected_rows() > 0;
  }
}
