<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/timepicker/1.3.5/jquery.timepicker.min.css">
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('marketing_campaigns'); ?>"><?= _l('marketing_campaigns') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['hr']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php echo form_open_multipart(admin_url('marketing_campaigns/campaign/' . set_value('id', $id ?? null)),
                                ['id' => 'marketing_campaign', 'class' => 'marketing_campaign']); ?>
                            <div class="row">
                                <div class="col-md-4">
                                    <?php echo render_input('name', 'name', set_value('name', isset($name) ? $name : '')); ?>
                                    <?php echo form_error('name', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_date_input('start', 'hr_start', set_value('start', isset($start) ? date('d-m-Y', strtotime($start)) : '')); ?>
                                    <?php echo form_error('start', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                                <div class="col-md-4">
                                    <?php echo render_date_input('end', 'hr_end', set_value('end', isset($end) ? date('d-m-Y', strtotime($end)) : '')); ?>
                                    <?php echo form_error('end', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <?php echo render_input('total_budget', 'total_budget', set_value('total_budget', isset($total_budget) ? $total_budget : ''), 'number'); ?>
                                    <?php echo form_error('total_budget', '<div class="error text-danger">', '</div>'); ?>
                                </div>
                            </div>

                            <div class="pd-y-15 bd-t">
                                <button class="btn btn-info travel-form-submit" type="submit"> <?php echo _l('save'); ?></button>
                                <a href="<?= admin_url('marketing_campaigns'); ?>" class="btn btn-info"><?php echo _l('back'); ?></a>
                            </div>
                            <?php echo form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>
