<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href="<?php echo admin_url(); ?>"><?= _l('breadcrumb_dashboard') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href="<?php echo admin_url('marketing_campaigns'); ?>"><?= _l('marketing_campaigns') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><?= $this->config->item('icons')['marketing']; ?>
            <?php echo html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-12">
                            <?php if (has_permission('marketing_campaigns', '', 'create')) { ?>
                                <div class="form-group">
                                    <a href="<?php echo admin_url('marketing_campaigns/campaign'); ?>" class="btn btn-info mg-r-5">
                                        <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE:echo _l('new_marketing_campaign'); ?>
                                    </a>
                                </div>
                            <?php } ?>
                            <?php
                            $table_data = [
                                _l('name'),
                                _l('start'),
                                _l('end'),
                                _l('total_budget'),

                                _l('action'),
                            ];

                            render_datatable($table_data, 'marketing_campaigns');
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
<script>
    notsearchable = [4];
    notsortable = [4];
    initDataTable('.table-marketing_campaigns', admin_url + 'marketing_campaigns/datatable', notsearchable, notsortable, 'undefined');
</script>
</body>
</html>
