
var fnServerParams;
Dropzone.autoDiscover = false;
var expenseDropzone;
(function($) {
	"use strict";

	fnServerParams = {
		"conver_to_expense": '[name="conver_to_expense"]',
    	"staff_filter": '[name="staff_filter"]',
    	"from_date": '[name="from_date"]',
    	"to_date": '[name="to_date"]',
	}



	if ($('#minutesForm').length > 0) {
          expenseDropzone = new Dropzone("#minutesForm", appCreateDropzoneOptions({
              autoProcessQueue: false,
              clickable: '#dropzoneDragArea',
              previewsContainer: '.dropzone-previews',
              addRemoveLinks: true,
              maxFiles: 10,
              success: function(file, response) {
                  if (this.getUploadingFiles().length === 0 && this.getQueuedFiles().length === 0) {
                      window.location.reload();
                  }
              }
        }));
    }

    appValidateForm($('#minutesForm'), {
          member_firstname: 'required',
          member_lastname: 'required',
          member_email: 'required'
    }, minutesSubmitHandler);

})(jQuery);





function minutesSubmitHandler(form) {
    "use strict";
      $.post(form.action, $(form).serialize()).done(function(response) {
          response = JSON.parse(response);
          if (response.expenseid) {
              if (typeof(expenseDropzone) !== 'undefined') {
                  if (expenseDropzone.getQueuedFiles().length > 0) {
                      expenseDropzone.options.url = admin_url + 'minutes/add_minute_attachment/' + response.expenseid;
                      expenseDropzone.processQueue();
                  } else {
                      window.location.assign(response.url);
                  }
              } else {
                  window.location.assign(response.url);
              }
          } else {
              window.location.assign(response.url);
          }
      });
      return false;
}
