<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Minutes extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['minutesModel', 'minuteMemberModel', 'minuteTaskModel', 'minuteFileModel']);
        $this->load->helper(['form', 'url']);
        $this->load->library('form_validation');
        // $this->lang->load('minutes');
        // Model is autoloaded
    }

    public function index()
    {
        // $this->output->enable_profiler(TRUE);
        if ( ! has_permission('minutes', '', 'view')) {
            access_denied('minutes');
        }
        if ($this->input->is_ajax_request()) {
            $this->app->get_table_data('minutes');
        }

        $data['minutes'] = $this->minutesModel->getAll();
        $data['title'] = _l('minutes');

        $this->load->view('minutes/globalView', $data);
    }


    /* Add new role or edit existing one */
    public function create($id = '')
    {


        if ( ! has_permission('minutes', '', 'create')) {
            access_denied('minutes');
        }

        if ($this->input->post()) {


            $minuteData = $this->input->post();
            // change data format
            $minuteData['start'] = date("Y-m-d", strtotime($minuteData['start'] ));
            // echo '<pre>';
            // print_r($minuteData);
            // exit;
            /***
             * Create
             */
            if ($id == '') {
                if ( ! has_permission('minutes', '', 'create')) {
                    access_denied('minutes');
                }
                $insertId = $this->minutesModel->create($minuteData);

                if ($insertId != false) {
                    set_alert('success', _l('added_successfully', _l('minutes_lowercase')));
                }
                redirect(admin_url('minutes'));
            }


            /***
             * Edit
             */
            if ( ! has_permission('minutes', '', 'edit')) {
                access_denied('minutes');
            }

            $insertId = $this->minutesModel->update($minuteData, $id);


            if ($insertId != false) {
                set_alert('success', _l('updated_successfully', _l('minutes_lowercase')));
            }
            redirect(admin_url('minutes'));

        }

        if ($id == '') {
            $title = _l('minute_add_new');
            $data['tasks'] = $data['members'] = $data['files'] = [];
        }

        if ( ! empty($id)) {

            $data['minute'] = $this->minutesModel->get($id);
            if (empty($data['minute']->id)) {
                show_404();
            }

            $data['tasks'] = $this->minuteTaskModel->getAllByMinuteId($id);
            $data['members'] = $this->minuteMemberModel->getAllByMinuteId($id);
            $data['files'] = $this->minuteFileModel->getAllByMinuteId($id);
            $title = _l('minute_edit_view').' '.$data['minute']->short;

        }

        $data['clients'] = $this->db->get(db_prefix().'clients')->result_array();
        $data['title'] = $title;
        $this->load->view('minutes/createView', $data);
    }

    public function delete($id = '')
    {
        // $this->output->enable_profiler(TRUE);
        if ( ! has_permission('minutes', '', 'delete')) {
            access_denied('minutes');
        }
        if (isset($id) && $id != null) {
            $this->minutesModel->delete($id);
            set_alert('success', _l('minute_deleted_successfully'));
            redirect(admin_url('minutes'));
        } else {
            set_alert('error',  _l('minute_deleted_failed'));
            redirect(admin_url('minutes'));
        }

    }

    public function uploadFileAjax($id = '')
    {
        $data = $this->minuteFileModel->saveFile($id);

        if($data['status'] == false){
            header('HTTP/1.0 400 Bad request', true, 400);

            return;
        }

        header('Content-Type: application/json');
        echo json_encode($data);

        return;
    }

    public function view($id)
    {
        if ( ! has_permission('minutes', '', 'view')) {
            access_denied('minutes');
        }
        $data['title'] = _l('minute_view_minute');
        $data['minute'] = $this->minutesModel->get($id);
        $data['tasks'] = $this->minuteTaskModel->getAllByMinuteId($id);
        $data['members'] = $this->minuteMemberModel->getAllByMinuteId($id);
        $data['files'] = $this->minuteFileModel->getAllByMinuteId($id);
        $this->load->view('minutes/minuteView', $data);
    }


}
