<?php

/**
 * Ensures that the module init file can't be accessed directly, only within the application.
 */

//use function GuzzleHttp\json_decode;

defined('BASEPATH') or exit('No direct script access allowed');
/*
Module Name: CRMconnect Minutes
Version: 1.0.0
*/
define('MINUTES_MODULE_NAME', 'minutes');

define('MINUTES_FOLDER', FCPATH . 'uploads/minutes' . '/');
// runs when module is been activated
register_activation_hook('minutes', 'setup_minutes_module');
hooks()->add_action('admin_init', 'minutes_register_permissions');
// add menu for admin
hooks()->add_action('admin_init', 'minutes_menu');

hooks()->add_action('app_admin_head', 'minutes_add_head_components');
hooks()->add_action('app_admin_footer', 'minutes_add_footer_components');

// adds translation file
register_language_files('minutes', ['minutes']);


/**
 * creates db operations for subscription products
 */
function setup_minutes_module()
{
    return true;
   //require(__DIR__ . '/install.php');
}

/**
 *  registers menu item for admin
 */
function minutes_menu()
{
    if (has_permission('minutes', '', 'view')) {
        $CI = &get_instance();
        /*$CI->app_menu->add_sidebar_menu_item('minutes', [
            'name'     => _l('Minutes'),
            'href'     => admin_url('minutes'),
            'icon'     => 'fal fa-presentation',
            'position' => 4,
        ]);*/



        $CI->app_menu->add_sidebar_children_item('agenda', ['slug'=>'minutes',
            'name'     => _l('Minutes'),
            'href'     => admin_url('minutes'),
            'position' => 5,
        ]);


    }
}
function minutes_register_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . '(' . _l('permission_global') . ')',
        'view_own'   => _l('permission_view_own'),
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities('minutes', $capabilities, _l('minutes'), _l('calendar_permissions'));
}





/**
 * commission add head components
 * @return
 */
function minutes_add_head_components()
{
    $CI = &get_instance();
    $viewuri = $_SERVER['REQUEST_URI'];

    if (!(strpos($viewuri, '/admin/minutes/create') === false)) {
        echo '<link href="' . module_dir_url(MINUTES_MODULE_NAME, 'assets/minutes.css') . '"  rel="stylesheet" type="text/css" />';
    }
}

/**
 * commission add footer components
 * @return
 */
function minutes_add_footer_components()
{
    $CI = &get_instance();
    $viewuri = $_SERVER['REQUEST_URI'];


    if (!(strpos($viewuri, '/admin/minutes/create') === false)) {
        echo '<script src="' . module_dir_url(MINUTES_MODULE_NAME, 'assets/minutes.js') . '"></script>';
    }


}
