<?php if ( ! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

define('MINUTES_UPLOAD_BASE', 'uploads/minutes/');

class minuteFileModel extends App_Model
{

    public $table_name = 'minutes_files';


    /**
     * @param  string  $id
     * @return array
     */
    public function saveFile($id = '')
    {


        $fileUploaded = upload_file_minute(MINUTES_UPLOAD_BASE);
        if ($fileUploaded['status'] == true) {
            $this->create([
                'filename' => $fileUploaded['filename'], 'original_filename' => $_FILES['file']['name'],
            ]);

        } else {
            return [
                'status' => false,
            ];

        }

        return [
            'status' => true, 'filename' => $fileUploaded['filename'], 'original_filename' => $_FILES['file']['name'],
        ];


    }

    /**
     * @param $datas
     * @param $id
     */
    public function relationFileByName($datas, $id)
    {
        $datas = array_filter($datas);

        foreach ($datas as $data) {
            $updateMinuteFile = [
                'minute_id' => $id,
            ];
            $this->db->where('filename', $data);
            $this->db->update($this->table_name, $updateMinuteFile);
        }

        return;
    }

    /**
     * @param $datas
     * @param  string  $id
     */
    public function create($datas, $id = '')
    {
        $data = [
            'minute_id' => $id, 'filename' => $datas['filename'], 'original_filename' => $datas['original_filename'],
        ];
        $this->db->insert($this->table_name, $data);

        return;
    }

    /**
     * @param $id
     */
    public function deleteAll($id)
    {

        $this->db->select('*');
        $this->db->where('minute_id', $id);
        $this->db->from($this->table_name);
        $results = $this->db->get()->result();

        foreach ($results as $result) {
            delete_file_minute(MINUTES_UPLOAD_BASE, $result->filename);
        }

        $this->db->where('minute_id', $id);
        $this->db->delete($this->table_name);

        return;
    }


    /**
     * @param $minuteId
     * @return mixed
     */
    public function getAllByMinuteId($minuteId)
    {
        $this->db->select('*');
        $this->db->where('minute_id', $minuteId);
        $this->db->from($this->table_name);
        $results = $this->db->get()->result();

        foreach ($results as $result) {
            $result->urlDownload = site_url(MINUTES_UPLOAD_BASE.$result->filename);
        }
        return $results;
    }

    /**
     * @param $files
     * @param $id
     */
    public function deleteWithoutOld($files, $id)
    {
        $oldIds = [];
        foreach ($files as $fileId) {
            $oldIds[] = $fileId;
        }

        if ( ! empty($oldIds)) {

            $this->db->select('*');
            $this->db->where('minute_id', $id);
            $this->db->where_not_in('id', $oldIds);
            $this->db->from($this->table_name);
            $results = $this->db->get()->result();

            foreach ($results as $result) {
                delete_file_minute(MINUTES_UPLOAD_BASE, $result->filename);
            }


            $this->db->where('minute_id', $id);
            $this->db->where_not_in('id', $oldIds);
            $this->db->delete($this->table_name);
        }
        return;
    }

}

?>