<?php  if(!defined('BASEPATH')) exit('No direct script access allowed');
class minuteMemberModel extends App_Model
{

    public $table_name = 'minutes_members';


    /**
     * @param $members
     * @param $minuteId
     */
    public function create($members, $minuteId){

        $members =   array_filter($members);
        foreach($members as $key => $member) {

            $members[$key]  =   explode(":",$member);
            $members[$key]  =   array_filter($members[$key]);
            $data   =   array(
                'minute_id'     =>  $minuteId,
                'first_name'    =>  !empty($members[$key][0]) ? $members[$key][0] : '',
                'last_name'     =>  !empty($members[$key][1]) ? $members[$key][1] : '',
                'email'         =>  !empty($members[$key][2]) ? $members[$key][2] : '',
                'phone'         =>  !empty($members[$key][3]) ? $members[$key][3] : '',
            );

            $this->db->insert($this->table_name, $data);
        }

        return;
    }

    /**
     * @param $minuteId
     * @return mixed
     */
    public function getAllByMinuteId($minuteId)
    {
        $this->db->select('*');
        $this->db->where('minute_id', $minuteId);
        $this->db->from($this->table_name);
        $results = $this->db->get()->result();

        foreach ($results as $result){
            $result->string_text = $result->first_name.' '.$result->last_name.'| '.$result->email.'/ '.$result->phone;
        }
        return $results;
    }

    /**
     * @param $members
     * @param $id
     */
    public function deleteWithoutOld($members, $id)
    {
        $oldIds = [];
        foreach ($members as $member){
            $oldIds[]= $member->id;
        }

        if(!empty($oldIds)){
            $this->db->where('minute_id', $id);
            $this->db->where_not_in('id', $oldIds);
            $this->db->delete($this->table_name);
        }



        return;
    }

    /**
     * @param $id
     */
    public function deleteAll($id)
    {
        $this->db->where('minute_id', $id);
        $this->db->delete($this->table_name);
        return;
    }

}
?>