<?php if ( ! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class minuteTaskModel extends App_Model
{
    public $table_name = 'minutes_tasks';

    /**
     * @param $tasks
     * @param $minuteId
     */
    public function create($tasks, $minuteId)
    {
        foreach ($tasks as $task) {
            if (empty($task)) {
                continue;
            }
            $data = [
                'minute_id' => $minuteId, 'task' => $task,
            ];
            $this->db->insert($this->table_name, $data);
        }

        return;
    }

    /**
     * @param $minuteId
     * @return mixed
     */
    public function getAllByMinuteId($minuteId)
    {
        $this->db->select('*');
        $this->db->where('minute_id', $minuteId);
        $this->db->from($this->table_name);
        $results = $this->db->get()->result();

        return $results;
    }

    /**
     * @param $tasks
     * @param $id
     */
    public function deleteWithoutOld($tasks, $id)
    {
        //pre($tasks);
        $oldIds = [];
        foreach ($tasks as $task) {
            $oldIds[] = $task->id;
        }
        if ( ! empty($oldIds)) {
            $this->db->where('minute_id', $id);
            $this->db->where_not_in('id', $oldIds);
            $this->db->delete($this->table_name);
        }

        return;
    }

    /**
     * @param $id
     */
    public function deleteAll($id)
    {
        $this->db->where('minute_id', $id);
        $this->db->delete($this->table_name);
        return;
    }

}

?>