<?php if ( ! defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class minutesModel extends App_Model
{


    public $table_name = 'minutes';

    public function __construct()
    {
        $this->load->model(['minuteMemberModel', 'minuteTaskModel', 'minuteFileModel']);
        $this->tableMinute = db_prefix().$this->table_name;
        $this->tableMinuteMember = db_prefix().$this->minuteMemberModel->table_name;
        $this->tableMinuteTask = db_prefix().$this->minuteTaskModel->table_name;
        $this->tableMinuteFile = db_prefix().$this->minuteFileModel->table_name;

        parent::__construct();


    }

    /**
     * @param $id
     * @return mixed
     */
    public function get($id)
    {
        $this->db->select('*');
        $this->db->where('id', $id);
        $this->db->from($this->tableMinute);
        return $this->db->get()->row();
    }

    /**
     * @param $datasPost
     * @return bool
     */
    public function create($datasPost)
    {
        $insertMinute = [
            'short' => $datasPost['short'],
            'start' => $datasPost['start'],
            'location' => $datasPost['location'],
            'rel_type' => $datasPost['rel_type'],
            'objectives' => $datasPost['objectives'],
            'achievements' => $datasPost['achievements'],
            'logistics' => $datasPost['logistics'],
            'followup' => $datasPost['followup'],
            'notes' => $datasPost['notes'],
            'offtopic' => $datasPost['offtopic'],
            'created_at' => date('c'),
        ];
        if(isset($datasPost['rel_id'])){
            $insertMinute['rel_id'] = $datasPost['rel_id'];
        }

        $this->db->insert($this->tableMinute, $insertMinute);
        $minuteId = $this->db->insert_id();

        if(empty($minuteId)){

            return false;
        }


        /**
         * Add member
         */
        if(!empty($datasPost['members'])){

            $this->minuteMemberModel->create($datasPost['members'], $minuteId);
        }

        /**
         * Add tasks
         */
        if(!empty($datasPost['tasks'])){

            $this->minuteTaskModel->create($datasPost['tasks'], $minuteId);
        }

        /**
         * Add files
         */
        if(!empty($datasPost['filesUploaded'])){

            $this->minuteFileModel->relationFileByName($datasPost['filesUploaded'], $minuteId);
        }

        return $minuteId;
    }

    /**
     * @param $datasPost
     * @param $id
     * @return mixed
     */
    public function update($datasPost, $id)
    {
        $updateMinute = [
            'short' => $datasPost['short'],
            'start' => $datasPost['start'],
            'location' => $datasPost['location'],
            'rel_type' => $datasPost['rel_type'],
            'rel_id' => $datasPost['rel_id'],
            'objectives' => $datasPost['objectives'],
            'achievements' => $datasPost['achievements'],
            'logistics' => $datasPost['logistics'],
            'followup' => $datasPost['followup'],
            'notes' => $datasPost['notes'],
            'offtopic' => $datasPost['offtopic'],
            'updated_at' => date('c'),
        ];
        $this->db->where('id', $id);
        $this->db->update($this->tableMinute, $updateMinute);


        /**
         * Delete old member
         */
        if(!empty($datasPost['oldMembers'])){
            $this->minuteMemberModel->deleteWithoutOld($datasPost['oldMembers'], $id);
        }else{
            $this->minuteMemberModel->deleteAll($id);
        }

        /**
         * Add member
         */
        if(!empty($datasPost['members'])){
            $this->minuteMemberModel->create($datasPost['members'], $id);
        }


        /**
         * Delete old tasks
         */
        if(!empty($datasPost['oldTasks'])){
            $this->minuteTaskModel->deleteWithoutOld($datasPost['oldTasks'], $id);
        }else{
            $this->minuteTaskModel->deleteAll($id);
        }

        /**
         * Add tasks
         */
        if(!empty($datasPost['tasks'])){
            $this->minuteTaskModel->create($datasPost['tasks'], $id);
        }


        /**
         * Delete old file
         */
        if(!empty($datasPost['oldFiles'])){
            $this->minuteFileModel->deleteWithoutOld($datasPost['oldFiles'], $id);
        }else{
            $this->minuteFileModel->deleteAll($id);
        }



        /**
         * Add files
         */
        if(!empty($datasPost['filesUploaded'])){

            $this->minuteFileModel->relationFileByName($datasPost['filesUploaded'], $id);
        }
        return $id;
    }

    /**
     * @return mixed
     */
    public function getAll()
    {

        $this->db->select('*');
        $this->db->from($this->tableMinute);
        $minuteResults = $this->db->get()->result();

        /***
         * Get Members
         */
        foreach ($minuteResults as $minute) {
            $minute->members = $this->getMembersByIs($minute->id);
        }


        return $minuteResults;
    }


    /**
     * @param $id
     * @return mixed
     */
    public function getMembersByIs($id)
    {
        $this->db->select('*');
        $this->db->from($this->tableMinuteMember);
        $this->db->where('minute_id', $id);

        return $this->db->get()->result();
    }


    /**
     * @param $id
     */
    public function delete($id)
    {
        /***
         * Minute
         */
        $this->db->where('id', $id);
        $this->db->delete($this->tableMinute);

        /***
         * Member
         */
        $this->db->where('minute_id', $id);
        $this->db->delete($this->tableMinuteMember);

        /***
         * Task
         */
        $this->db->where('minute_id', $id);
        $this->db->delete($this->tableMinuteTask);

        /***
         * Files
         */
        $this->db->where('minute_id', $id);
        $this->db->delete($this->tableMinuteFile);
        return;
    }
}

?>
