<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php
$rel_type = (!empty($this->input->get('rel_type'))) ? $this->input->get('rel_type') : ((!empty($minute->rel_type)) ? $minute->rel_type : '');
$rel_id = (!empty($this->input->get('rel_id'))) ? $this->input->get('rel_id') : ((!empty($minute->rel_id)) ? $minute->rel_id : '');
?>
<style>
    .dropzoneMy {

        height: 200px;
        background-color: #e9ecef;
        align-items: center !important;
        justify-content: center !important;
        display: flex !important;
    }

    .inputfileLabel {
        margin-bottom: 0;
        font-weight: 550 !important;
        text-overflow: ellipsis;
        white-space: nowrap;
        cursor: pointer;
        display: inline-block;
        overflow: hidden;
        padding: 8px 20px;
        border-radius: 3px;
        transition: all 0.2s ease-in-out;
    }

    .tx-white {
        color: #fff;
    }

    .dropzoneMy i {
        vertical-align: middle;
        margin-top: -0.25em;
        margin-right: 10px;
        line-height: 0;
    }
</style>


<div id="wrapper">
    <div class="breadcrumb">
        <a href=" <?= admin_url(); ?>"><?= _l('okr_dashboard') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href=" <?= admin_url("minutes"); ?>"> <?= _l('menu_agenda'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp; <?= html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1> <?= html_entity_decode($title); ?></h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <?php /*echo form_open($this->uri->uri_string(),['id' => 'minutesForm']);*/ ?>
                        <?php
                        $admin_url = !empty($minute->id) ? admin_url('minutes/create/' . $minute->id) : admin_url('minutes/create');
                        echo form_open_multipart($admin_url,
                            ['id' => 'minutesForm', 'class' => 'dropzone dropzone-manual']);

                        ?>
                        <div class="row">
                            <div class="col-xs-12 col-md-6">
                                <?= render_input('short', _l('short_text'), (isset($minute) ? $minute->short : ''),
                                    'text', ['autofocus' => true, 'required' => true]); ?>
                            </div>
                            <div class="col-xs-12 col-md-3">
                                <?= render_date_input('start', _l('start_text'),
                                    (isset($minute) ? $minute->start : '')); ?>
                            </div>
                            <div class="col-xs-12 col-md-3">
                                <?= render_input('location', _l('location_text'),
                                    (isset($minute) ? $minute->location : ''), 'text'); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="rel_type" class="control-label"> <?= _l('task_related_to'); ?></label>
                                    <select name="rel_type" class="selectpicker" id="rel_type" data-width="100%" data-none-selected-text=" <?= _l('dropdown_non_selected_tex'); ?>">
                                        <option value=""></option>
                                        <option value="project"
                                            <?php
                                            if ($rel_type == 'project') {
                                                echo 'selected';
                                            }
                                            ?>> <?= _l('project'); ?></option>
                                        <option value="customer"
                                            <?php
                                            if ($rel_type == 'customer') {
                                                echo 'selected';
                                            }
                                            ?>>
                                            <?= _l('client'); ?>
                                        </option>
                                        <option value="contract" <?php
                                        if ($rel_type == 'contract') {
                                            echo 'selected';
                                        }
                                        ?>>
                                            <?= _l('contract'); ?>
                                        </option>
                                        <option value="vendor" <?php
                                        if ($rel_type == 'vendor') {
                                            echo 'selected';
                                        }
                                        ?>>
                                            <?= _l('vendor'); ?>
                                        </option>
                                        <option value="lead" <?php
                                        if ($rel_type == 'lead') {
                                            echo 'selected';
                                        }
                                        ?>>
                                            <?= _l('lead'); ?>
                                        </option>
                                        <option value="internal"> Internal</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group hide" id="rel_id_wrapper">
                                    <label for="rel_id" class="control-label"><span class="rel_id_label"><?= _l('customer'); ?></span></label>
                                    <div id="rel_id_select">
                                        <select name="rel_id" id="rel_id" class="ajax-sesarch" data-width="100%" data-live-search="true" data-none-selected-text=" <?= _l('dropdown_non_selected_tex'); ?>">
                                            <?php if ($rel_id != '' && $rel_type != '') {
                                                $rel_data = get_relation_data($rel_type, $rel_id);
                                                $rel_val = get_relation_values($rel_data, $rel_type);
                                                echo '<option value="' . $rel_val['id'] . '" selected>' . $rel_val['name'] . '</option>';
                                            } ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-xs-12 col-md-6">
                                <label for="location" class="control-label"><?= _l('minute_members') ?></label>

                                <div class="input-group members">

                                    <?php foreach ($members as $member) { ?>
                                        <div id="js-member-<?= $member->id ?>" style="    width: 100%;    display: flex; ">
                                            <p><?= $member->string_text ?></p>
                                            <a style="color: red; cursor: pointer;" href="#" onclick="$('#js-member-<?= $member->id ?>').remove()">
                                                <i class="fa fa-delete-left"></i></a>
                                            <input type="hidden" id="tasks" name="oldMembers[<?= $member->id ?>]" class="form-control" value="<?= $member->id ?>">
                                        </div>
                                    <?php } ?>

                                </div>
                                <small class="add-member" style="color: red; cursor: pointer;"><a class="btn btn-info pull-left display-block hidden-xs">
                                        <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?= _l('minute_add_members') ?>
                                    </a></small>
                            </div>
                        </div>
                        <?= render_textarea('objectives', _l('objectives_text'),
                            (isset($minute) ? $minute->objectives : '')); ?>
                        <?= render_textarea('achievements', _l('achievements_text'),
                            (isset($minute) ? $minute->achievements : '')); ?>
                        <div class="form-group tasks" app-field-wrapper="tasks[]">


                            <label for="tasks[]" class="control-label"><span class="append"><a class="btn btn-info pull-left display-block hidden-xs"> <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?= _l('tasks_text'); ?> </a></span></label>

                            <div class="js-task input-group" style="    width: 100%;    display: flex; padding-top: 10px;">
                                <input type="text" id="tasks" name="tasks[]" class="form-control" value="">
                                <div class="input-group-append">
                                    <button class="btn btn-danger" onclick="$(this).parents('.js-task').remove();" type="button">
                                        <i class="fa fa-delete-left"></i></button>
                                </div>
                            </div>

                            <?php foreach ($tasks as $task) { ?>
                                <div id="js-task-<?= $task->id ?>" class="input-group" style="    width: 100%;    display: flex; padding-top: 10px;">
                                    <input type="text" id="tasks" name="oldTasks[<?= $task->id ?>]" class="form-control" value="<?= $task->task ?>">
                                    <div class="input-group-append">
                                        <button class="btn btn-danger" onclick="$('#js-task-<?= $task->id ?>').remove()" type="button">
                                            <i class="fa fa-delete-left"></i></button>
                                    </div>
                                </div>
                            <?php } ?>

                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-md-6">
                                <?= render_textarea('logistics', _l('logistics_text'),
                                    (isset($minute) ? $minute->logistics : '')); ?>
                            </div>
                            <div class="col-xs-12 col-md-6">
                                <?= render_textarea('followup', _l('followup_text'),
                                    (isset($minute) ? $minute->followup : '')); ?>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-md-6">
                                <?= render_textarea('notes', _l('notes_text'),
                                    (isset($minute) ? $minute->notes : '')); ?>
                            </div>
                            <div class="col-xs-12 col-md-6">
                                <?= render_textarea('offtopic', _l('offtopic_text'),
                                    (isset($minute) ? $minute->offtopic : '')); ?>
                            </div>
                        </div>

                        <div id="dropzoneDragArea" class="dz-default dz-message dropzoneMy" style="margin-top:20px;">

                            <label for="file-1" class="inputfileLabel tx-white bg-info">
                                <i class="icon ion-ios-upload-outline tx-24"></i><?= _l('minute_file_button'); ?>
                            </label>
                        </div>
                        <div class="dropzone-previews"></div>

                        <div id="js-block-filesUploaded">
                        </div>


                        <div class="row">
                            <?php foreach ($files as $file) { ?>
                                <div class="col-md-6 js-old-file">
                                    <p>
                                        <a href="<?= $file->urlDownload ?>"><?= $file->original_filename ?></a>
                                        <span onclick="$(this).parents('.js-old-file').remove();" style="color: red; cursor: pointer;">X</span>
                                        <input value="<?= $file->id ?>" type="hidden" name="oldFiles[<?= $file->id ?>]"/>
                                    </p>
                                </div>
                            <?php } ?>
                        </div>

                        <button type="submit" class="btn btn-info pull-right"> <?= _l('submit'); ?></button>
                        <? echo form_close(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<div class="d-none model-data">
    <div class="js-task  js-task-copy input-group hide" style=" width: 100%;display: flex; padding-top: 10px;">
        <input type="text" id="tasks" name="tasks[]" class="form-control" value="">
        <div class="input-group-append">
            <button class="btn btn-danger" onclick="$(this).parents('.js-task').remove();" type="button">
                <i class="fa fa-delete-left"></i></button>
        </div>
    </div>
</div>


<div class="modal fade" id="container-modal" tabindex="-1" role="dialog" aria-labelledby="minuteCenteredModal" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"><?= _l('modal_title_text'); ?></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-6">
                            <?= render_input('member_firstname', _l('member_fname_text'), '', 'text',
                                ['autofocus' => true, 'required' => true]); ?>
                        </div>
                        <div class="col-md-6">
                            <?= render_input('member_lastname', _l('member_lname_text'), '', 'text',
                                ['required' => true]); ?>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <?= render_input('member_email', _l('member_email_text'), '', 'text',
                                ['required' => true]); ?>
                        </div>
                        <div class="col-md-6">
                            <?= render_input('member_phone', _l('member_phone_text'), '', 'text',
                                ['required' => true]); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal"><?= _l('close'); ?></button>
                <button type="button" id="js-addBtn" class="btn btn-primary"><?= _l('add_member_text'); ?></button>
            </div>
        </div>
    </div>
</div>


<div class="js-task js-task-copy input-group hide" style="    width: 100%;    display: flex; padding-top: 10px;">
    <input type="text" id="tasks" name="tasks[]" class="form-control" value="">
    <div class="input-group-append">
        <button class="btn btn-danger" onclick="$(this).parents('.js-task').remove();" type="button">
            <i class="fa fa-delete-left"></i></button>
    </div>
</div>

<div class="js-member js-member-copy hide" style="    width: 100%;    display: flex; ">
    <p id="js-text"></p>
    <a style="color: red; cursor: pointer;" href="#" onclick="$(this).parents('.js-member').remove();">
        <i class="fa fa-delete-left"></i></a>
    <input value="" type="hidden" id="js-members-input" name="members[]"/>
</div>
<?php show_footer(); ?>
<?php init_tail(); ?>


<script>
    var fnServerParams;
    Dropzone.autoDiscover = false;

    $(function () {
        if (Dropzone.instances.length > 0) Dropzone.instances.forEach(dz => dz.destroy())
        var expenseDropzone = new Dropzone("#minutesForm", {
            url: '<?=(!empty($minute->id)) ? site_url('admin/minutes/uploadFileAjax/' . $minute->id) : site_url('admin/minutes/uploadFileAjax')?>',
            autoProcessQueue: true,
            clickable: '#dropzoneDragArea',
            previewsContainer: '.dropzone-previews',
            addRemoveLinks: true,
            // maxFiles: 1,
            //acceptedFiles: "image/*,application/pdf,application/zip,application/rar,.doc,.docx,.xls,.xlsx,.csv,.tsv,.ppt,.pptx,.pages,.odt,.rtf",
            acceptedFiles: "image/*,application/pdf,.doc,.docx,.xls,.xlsx,.ppt,.pptx,.txt,.rtf,.zip,.rar,.csv,.tsv",
            // removedfile: function (file) {
            //     console.log(file);
            //     file.previewElement.remove();
            // },
            success: function (file, response) {
                if (response.status == true) {
                    $('#js-block-filesUploaded').append('  <input type="hidden" value="' + response.filename + '" name="filesUploaded[]" id="js-filesUploaded">');
                }
            },
        });


    });


    var _rel_id = $('#rel_id'),
        _rel_type = $('#rel_type'),
        _rel_id_wrapper = $('#rel_id_wrapper'),
        data = {};

    if (_rel_type.val() != '' && _rel_type.val() != 'internal') {
        task_rel_select();
    }


    $(function () {
        _validate_form($('form'), {name: 'required'});
    });
    $('.add-member').on('click', function () {
        $('#container-modal').modal();
    })

    $('#js-addBtn').on('click', function () {

        var fn = $('#container-modal #member_firstname').val();
        var ln = $('#container-modal #member_lastname').val();
        var em = $('#container-modal #member_email').val();
        var ph = $('#container-modal #member_phone').val();
        var editedItem = fn + ':';
        editedItem += ln + ':';
        editedItem += em + ':';
        editedItem += ph + ':';

        var text = '<p>' + fn + ' ' + ln + '| ' + em + '/ ' + ph + '</p>';
        var htmlCopy = $('.js-member-copy').clone();
        $(htmlCopy).removeClass('hide').removeClass('js-member-copy');
        $(htmlCopy).find('p#js-text').html(text);
        $(htmlCopy).find('input#js-members-input').val(editedItem);
        $('.members').append($(htmlCopy));

        $('#container-modal :input').val('');
        $('#container-modal').modal('hide');
    });

    _rel_type.on('change', function () {

        var clonedSelect = _rel_id.html('').clone();
        _rel_id.selectpicker('destroy').remove();
        _rel_id = clonedSelect;
        $('#rel_id_select').append(clonedSelect);
        $('.rel_id_label').html(_rel_type.find('option:selected').text());

        task_rel_select();
        console.log($(this).val());
        if ($(this).val() != '' && $(this).val() != 'internal') {
            _rel_id_wrapper.removeClass('hide');
        } else {
            _rel_id_wrapper.addClass('hide');
            $('#rel_id').hide();
        }

    });


    $('.append').on('click', function () {
        var task = $('.tasks').find("input:last").val();
        // var taskCount = $('.tasks').find($("input"));
        // if (!task) {
        /* Swal.fire({
             title: 'Error!',
             text: '<?=_l('minute_many_tasks')?>',
                icon: 'error',
                confirmButtonText: '<?=_l('minute_continue')?>'
            })*/
        // } else {
        //var htmlCopy = $('.js-task-copy').clone();
        var htmlCopy = $('.model-data .js-task-copy').clone();


        $(htmlCopy).removeClass('hide').removeClass('js-task-copy');
        $('.form-group.tasks').append($(htmlCopy));
        //}
    })

    function task_rel_select() {
        var serverData = {};
        serverData.rel_id = _rel_id.val();
        serverData.type = _rel_type.val();
        init_ajax_search(_rel_type.val(), _rel_id, serverData);
        _rel_id_wrapper.removeClass('hide');
    }


</script>
</body>
</html>
