<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href=" <?= admin_url(); ?>"><?= _l('okr_dashboard') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href=" <?= admin_url("minutes"); ?>"> <?= _l('menu_agenda'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp; <?= html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <h1><i class="fal fa-calendar-alt"></i> <?= html_entity_decode($title); ?> </h1>
    </div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="_buttons">
                            <a href=" <?= admin_url('minutes/create'); ?>" class="btn btn-info mright5 test pull-left display-block">
                                <i class="plus-icon-new fa-sharp fa-solid fa-plus"></i> <?php //INACTIVE:echo _l('minute_view_minute'); ?><?php //_l('add_new',_l('minute_module')); ?>
                            </a>
                        </div>
                        <div class="clearfix mtop20"></div>
                        <div class="row col-md-12">
                            <hr>
                        </div>
                        <table class="table table-vendors">
                            <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col"><?= _l('minute_short_description') ?></th>
                                <th scope="col"><?= _l('date') ?></th>
                                <th scope="col"><?= _l('members_text') ?></th>
                                <th scope="col"><?= _l('objectives_text') ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($minutes as $minute) { ?>
                                <tr>
                                    <th scope="row"><?= $minute->id; ?></th>
                                    <td>
                                        <?= $minute->short; ?>
                                        <div class="row-options">
                                            <a href=" <?= admin_url('minutes/view/' . $minute->id); ?>"><?= _l('minute_view') ?></a>
                                            |
                                            <a href=" <?= admin_url('minutes/create/' . $minute->id); ?>"> <?= _l('minute_edit') ?> </a>
                                            |
                                            <a href=" <?= admin_url('minutes/delete/' . $minute->id); ?>" class="text-danger _delete"><?= _l('minute_delete') ?></a>
                                        </div>
                                    </td>
                                    <td><?= _d($minute->created_at); ?></td>
                                    <td>
                                        <?php
                                        if (isset($minute->members)) {
                                            foreach ($minute->members as $member) {
                                                echo $member->first_name . ' ' . $member->last_name . '<br>';
                                            }
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?= mb_strimwidth($minute->objectives, 0, 150, '...'); ?>
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php show_footer(); ?><?php init_tail(); ?>
<script>
    initDataTable('.table-vendors1', window.location.href, [1], [1]);
</script>
</body>
</html>
