<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="breadcrumb">
        <a href=" <?= admin_url(); ?>"><?= _l('okr_dashboard') ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<a href=" <?= admin_url("minutes"); ?>"> <?= _l('menu_agenda'); ?></a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp; <?= html_entity_decode($title); ?>
    </div>
    <div class="admin-title">
        <div class="admin-title">
            <h1><i class="fal fa-calendar-alt"></i> <?php echo html_entity_decode($title); ?></h1>
        </div>
    </div>
    <div class="content">
        <div class="row">
            <div class="panel_s">
                <div class="panel-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p>
                            <h4><?= _l('short_text'); ?></h4>
                            <?= $minute->short; ?>
                            </p>
                            <hr>
                            <?php if ( ! empty($minute->objectives)) { ?>
                                <p>
                                <h4><?= _l('objectives_text'); ?></h4>
                                <?= $minute->objectives; ?>
                                </p>
                            <hr>  
                            <?php } ?>

                            <?php if ( ! empty($minute->achievements)) { ?>
                                <p>
                                <h4><?= _l('achievements_text'); ?></h4>
                                <?= $minute->achievements; ?>
                                </p>
                            <hr>   
                            <?php } ?>

                            <?php if ( ! empty($minute->logistics)) { ?>
                                <p>
                                <h4><?= _l('logistics_text'); ?></h4>
                                <?= $minute->logistics; ?>
                                </p>
                                <hr>  
                            <?php } ?>

                            <?php if ( ! empty($members)) { ?>
                                <p>
                                <h4><?= _l('minute_discusion_members') ?></h4>
                                <?php foreach ($members as $member) { ?>
                                    <span><?= $member->string_text ?></span><br>
                                <?php } ?>
                                </p>
                                <hr> 
                            <?php } ?>
                        </div>

                        <div class="col-md-6">

                            <p>
                                <h4><?= _l('date'); ?></h4>
                                <?= $newDate = date("d-m-Y", strtotime($minute->created_at)); ?>
                            </p>
                            <hr>


                            <?php if ( ! empty($minute->offtopic)) { ?>
                                <p>
                                <h4><?= _l('offtopic_text'); ?></h4>
                                <?= $minute->offtopic; ?>
                                </p>
                                <hr> 
                            <?php } ?>

                            <?php if ( ! empty($minute->followup)) { ?>
                                <p>
                                <h4><?= _l('followup_text'); ?></h4>
                                <?= $minute->followup; ?>
                                </p>
                                <hr> 
                            <?php } ?>

                            <?php if ( ! empty($minute->notes)) { ?>
                                <p>
                                <h4><?= _l('notes_text'); ?></h4>
                                <?= $minute->notes; ?>
                                </p>
                                <hr> 
                            <?php } ?>



                            <?php if ( ! empty($tasks)) { ?>
                                <p>
                                <h4><?= _l('minute_tasks') ?></h4>
                                <?php foreach ($tasks as $task) {
                                    echo $task->task.'<br>';
                                }
                                ?>
                                </p>
                                <hr> 
                            <?php } ?>
                           
                        </div>
                    </div>

                    <?php if ( ! empty($files)) { ?>
                        <div class="row">
                            <div class="col-md-12">
                                <h4><?= _l('minute_files') ?></h4>
                                <hr>
                                <div class="row">
                                    <?php foreach ($files as $file) { ?>
                                        <div class="col-md-6 js-old-file">
                                            <p>
                                                <a href="<?= $file->urlDownload ?>"> <i class="far fa-file" aria-hidden="true"></i> <?= $file->original_filename ?></a>
                                            </p>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php show_footer(); ?><?php init_tail(); ?>
</body>
</html>