<?php hooks()->do_action('head_element_client'); ?>
<?php if ($detailt_product != null) { ?>
    <?php $id = $detailt_product->id;
    $currency_name = '';
    if (isset($base_currency)) {
        $currency_name = $base_currency->name;
    }
    $array_list_id = [];
    if (isset($_COOKIE['cart_id_list'])) {
        $list_id = $_COOKIE['cart_id_list'];
        if ($list_id) {
            $array_list_id = explode(',', $list_id);
        }
    }

    $tax_value = 0;
    $tax_data = $this->omni_sales_model->get_tax_info_by_product($id);
    $price_exluded_vat = $price;
    if ($tax_data) {
        $tax_value = $tax_data->taxrate;
        if ($tax_value > 0) {
            $price = $price * (1 + ($tax_value / 100));
        }
    }

    $user_id = '';
    if (is_client_logged_in()) {
        $user_id = get_client_user_id();
    }

    $date = date('Y-m-d');
    $discount_percent = 0;
    $prices_discount = 0;

    $discount = $this->omni_sales_model->get_discount_item_portal($id, $user_id, $date);
    if ($discount) {
        $discount_percent = $discount->discount;
        $prices_discount = $price - (($discount_percent * $price) / 100);
    }


    ?>

    <div class="wrapper row">
        <div class="panel_s mbot25">
            <div class="panel-body">
                <input type="hidden" name="parent_id" value="<?php echo htmlentities($id); ?>">
                <input type="hidden" name="id" value="<?php echo htmlentities($id); ?>">
                <div class="preview col-md-4">
                    <div class="preview-pic tab-content">
                        <?php
                        $date = date('Y-m-d');
                        $html_listimage = '';
                        $active = 'active';
                        $list_filename = $this->omni_sales_model->get_all_image_file_name($id);
                        foreach ($list_filename as $key => $value) {
                            $is_image_exist = false;
                            $mode = '';
                            if (file_exists('modules/warehouse/uploads/item_img/' . $id . '/' . $value["file_name"])) {
                                $is_image_exist = true;
                                $mode = 'warehouse';
                            } elseif (file_exists('modules/purchase/uploads/item_img/' . $id . '/' . $value["file_name"])) {
                                $is_image_exist = true;
                                $mode = 'purchase';
                            } elseif (file_exists('modules/manufacturing/uploads/products/' . $id . '/' . $value["file_name"])) {
                                $is_image_exist = true;
                                $mode = 'manufacturing';
                            }

                            if ($is_image_exist == true) {

                                ?>
                                <div class="contain_image tab-pane <?php echo html_entity_decode($active); ?>"
                                        id="pic-<?php echo html_entity_decode($key); ?>">
                                    <img src="<?php echo omni_check_image_items($id, $value['file_name'], $mode); ?>"/>
                                </div>
                                <?php
                                $active = '';
                                $html_listimage .= '<li class="' . html_entity_decode($active) . '"><a data-target="#pic-' . html_entity_decode($key) . '" data-toggle="tab"><img src="' . omni_check_image_items($id, $value['file_name'], $mode) . '" /></a></li>';
                            }
                        }

                        if ($html_listimage == '') {
                            $active = 'active';
                            $file_path = 'modules/omni_sales/assets/images/no_image.jpg';

                            ?>
                            <div class="contain_image tab-pane <?php echo html_entity_decode($active); ?>"
                                    id="pic-<?php echo html_entity_decode(0); ?>">
                                <img src="<?php echo site_url($file_path); ?>"/>
                            </div>
                            <?php
                            $html_listimage .= '<li class="' . html_entity_decode($active) . '"><a data-target="#pic-' . html_entity_decode(0) . '" data-toggle="tab"><img src="' . site_url($file_path) . '" /></a></li>';
                        }

                        ?>
                    </div>
                    <ul class="preview-thumbnail nav nav-tabs">
                        <?php echo html_entity_decode($html_listimage); ?>
                    </ul>
                </div>

                <div class="details col-md-6">
                    <h3 class="product-title"><?php echo html_entity_decode($detailt_product->description); ?></h3>
                    <h3 class="product-title sub hide"></h3>
                    <span class="product-description"><a href="<?php echo site_url('omni_sales/omni_sales_client/index/1/' . $group_id); ?>"><?php echo _l('category') . ': ' . $group; ?></a></span>

                    <p class="product-description"><?php echo html_entity_decode($detailt_product->long_description); ?></p>
                    <p class="product-description sub hide"></p>
                    <h4 class="price">

                        <?php echo _l('price') . ': '; ?>
                        <?php if ($discount_percent > 0) {
                            ?>
                            <span class="new-price text-danger"><?php echo app_format_money($prices_discount, $currency_name); ?> </span>
                            <span class="new-price sub"><?php echo app_format_money($price, $currency_name); ?></span>
                            <small class="text-danger border rounded border-danger badge float-left bg-white"><?php echo html_entity_decode('-' . $discount_percent . '%') ?></small>
                        <?php } else { ?>
                            <span class="new-price text-danger"><?php echo app_format_money($price, $currency_name); ?></span>
                            <?php if (isset($tax_data->name)) { ?>
                                <span class="small-text"> (<?php echo _l('vat_included'); ?> <?php if (isset($tax_data->name)) {
                                        echo $tax_data->taxrate;
                                    } ?> %)</span>
                            <?php } ?>
                            <span class="small-text"><?php echo app_format_money($price_exluded_vat, $currency_name); ?></span>
                            <span class="small-text"> (<?php echo _l('without_vat'); ?>)</span>
                        <?php } ?>

                    </h4>

                    <table class="table table-bordered table-discount">
                        <thead>
                        <tr>
                            <th><?php echo _l('number_of_pieces') ?></th>
                            <th><?php echo _l('volume_discount') ?></th>
                            <th><?php echo _l('price_with_vat') ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <td>0 - 30</td>
                            <td>-5%</td>
                            <td><?php echo app_format_money(($price - ($price * (5 / 100))), $currency_name); ?></td>
                        </tr>
                        <tr>
                            <td>31 - 60</td>
                            <td>-10%</td>
                            <td><?php echo app_format_money(($price - ($price * (10 / 100))), $currency_name); ?></td>
                        </tr>
                        <tr>
                            <td>61 - 90</td>
                            <td>-15%</td>
                            <td><?php echo app_format_money(($price - ($price * (15 / 100))), $currency_name); ?></td>
                        </tr>
                        <tr>
                            <td>91 - 120</td>
                            <td>-20%</td>
                            <td><?php echo app_format_money(($price - ($price * (20 / 100))), $currency_name); ?></td>
                        </tr>
                        <tr>
                            <td>121 - 150</td>
                            <td>-25%</td>
                            <td><?php echo app_format_money(($price - ($price * (25 / 100))), $currency_name); ?></td>
                        </tr>
                        </tbody>
                    </table>


                    <?php
                    $str = $_data = '';
                    if (isset($arr_warehouse_by_item[$detailt_product->id]) > 0) {
                        foreach ($arr_warehouse_by_item[$detailt_product->id] as $wh_key => $warehouse_value) {
                            $str = '';
                            if ($warehouse_value['warehouse_id'] != '' && $warehouse_value['warehouse_id'] != '0') {
                                //get inventory quantity
                                $quantity_by_warehouse = $warehouse_value['inventory_number'];
                                if (isset($arr_warehouse_id[$warehouse_value['warehouse_id']])) {

                                    $str .= '<span class=""><span class="tag">' . $arr_warehouse_id[$warehouse_value['warehouse_id']]['warehouse_name'] . ':(' . $quantity_by_warehouse . ')</span><span class="hide">,</span></span>&nbsp';

                                    $_data .= $str;
//                                    if($wh_key%3 ==0){
//                                        $_data .='<br/>';
//                                    }
                                }

                            }
                        }

                    } else {
                        $_data = '';
                    }

                    if ($amount_in_stock > 0) {
                        echo '<div class="availability">';
                        echo '<i class="fal fa-check-circle"></i>';
                        echo '<span>' . _l('in_stock') . '</span>' . $_data; // (' . html_entity_decode($amount_in_stock) . ')
                        echo '</div>';
                    } else {
                        echo '<div class="not-availability">';
                        echo '<i class="fal fa-times-circle"></i>';
                        echo '<span>Stoc epuizat</span>';
                        echo '</div>    ';
                    }


                    ?>
                    <br>
                    <div class="col-md-12">
                        <input type="hidden" name="quantity_available"
                                value="<?php echo html_entity_decode($amount_in_stock); ?>">
                    </div>
                    <?php
                    $has_classify = 0;
                    $classify_list = json_decode($detailt_product->parent_attributes);
                    if (isset($classify_list) && !empty($classify_list) && count($classify_list) > 0) {
                        foreach ($classify_list as $key => $classify) {
                            if ($has_classify == 0) {
                                if ($classify->name == "") {
                                    $has_classify = 0;
                                    break;
                                } else {
                                    $has_classify = 1;
                                }
                            }
                            ?>
                            <div class="row variation-row row-<?php echo html_entity_decode($key); ?>">
                                <div class="col-md-12 variation-items">
                                    <label><?php echo html_entity_decode($classify->name); ?></label><br>
                                    <?php
                                    foreach ($classify->options as $options) { ?>
                                        <button class="label label-default product-variation">
                                            <?php echo html_entity_decode($options); ?>
                                        </button>
                                        <?php
                                    } ?>
                                </div>
                            </div><br>
                        <?php } ?>
                        <label class="amount_available hide"><?php echo _l('amount_available'); ?>: <span
                                    id="amount_available"></span></label>
                    <?php } ?>
                    <input type="hidden" name="has_classify" value="<?php echo html_entity_decode($has_classify); ?>">
                    <input type="hidden" name="msg_classify" value="<?php echo _l('please_choose'); ?>">
                    <br>
                    <div class="action row">
                        <div class="col-md-12 mbot20">
                            <div class="form-group pull-left">
                                <div class="input-group">
							<span class="input-group-addon minus" onclick="change_qty(-1);">
								<i class="fa fa-minus"></i>
							</span>
                                    <input id="quantity" class="form-control text-center" type="number" value="1"
                                            min="1" max="<?php echo html_entity_decode($amount_in_stock); ?>">
                                    <span class="input-group-addon plus" onclick="change_qty(1);">
								<i class="fa fa-plus"></i>
							</span>
                                </div>
                            </div>

                            <?php if ($amount_in_stock > 0) { ?>
                                <button class="btn btn-success pull-left mleft10 add_to_cart <?php if (in_array($id, $array_list_id)) {
                                    echo 'hide';
                                } else {
                                    echo '';
                                } ?>" type="button">
                                    <i class="fa fa-shopping-cart"></i> <?php echo _l('add_to_cart'); ?>
                                </button>
                                <button class="btn btn-primary pull-left mleft10 added_to_cart <?php if (in_array($id, $array_list_id)) {
                                    echo '';
                                } else {
                                    echo 'hide';
                                } ?>" type="button">
                                    <i class="fa fa-check"></i> <?php echo _l('added'); ?>
                                </button>
                                <?php
                            } elseif ($has_classify) { ?>
                                <button class="btn btn-success pull-left mleft10 add_to_cart" type="button">
                                    <i class="fa fa-shopping-cart"></i> <?php echo _l('add_to_cart'); ?>
                                </button>
                            <?php } else { ?>
                                <button class="btn btn-default pull-left mleft10"
                                        type="button"><?php echo _l('out_of_stock'); ?></button>
                            <?php } ?>

                            <div class="clearfix"></div>


                        </div>

                        <?php
                        echo '<div class="col-lg-1 col-md-2">';
                        echo '<i class="fal fa-shipping-fast fa-3x"></i>';
                        echo '</div>';
                        echo '<div class="col-md-6 col-sm-7">';
                        echo '<b>' . _l('delivery_time') . '</b><br>';
                        echo '<div class="text-success"><b>' . strftime("%A, %e %B %Y", strtotime('+ 1 weekdays')) . '</b></div>';
                        $shipping_fee = get_option('omni_portal_shipping_fee');
                        if ($shipping_fee != 0) {
                            echo _l('omni_shipping_fee') . ' : ' . app_format_money($shipping_fee, $currency_name);
                        } else {
                            echo _l('omni_shipping_fee') . ' : <span class="text-success uppercase"><b>' . _l('free') . '</b></span>';
                        }
                        echo '</div>';
                        echo '</div>';
                        echo '<div class="col-12 col-sm-12">';

                        ?>
                    </div>

                    <div class="row">
                        <div class="col-md-10">
                            <ul class="mtop30">

                                <?php if ($detailt_product->commodity_code) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold" width="30%"><?php echo _l('commodity_code'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->commodity_code); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->description) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('commodity_name'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->description); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->group_id) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('commodity_group'); ?></span>:
                                        <span><?php echo get_wh_group_name(html_entity_decode($detailt_product->group_id)) != null ? get_wh_group_name(html_entity_decode($detailt_product->group_id))->name : ''; ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->commodity_barcode) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('commodity_barcode'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->commodity_barcode); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->sku_code) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('sku_code'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->sku_code); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->sku_name) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('sku_name'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->sku_name); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->tax) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('tax_1'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->tax) != '' && get_tax_rate($detailt_product->tax) != null ? get_tax_rate($detailt_product->tax)->name : ''; ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($detailt_product->tax2) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('tax_2'); ?></span>:
                                        <span><?php echo html_entity_decode($detailt_product->tax2) != '' && get_tax_rate($detailt_product->tax2) != null ? get_tax_rate($detailt_product->tax2)->name : ''; ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($commodites->origin) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold td-width"><?php echo _l('origin'); ?></span>:
                                        <span><?php echo html_entity_decode($commodites->origin); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($commodites->color) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('colors'); ?></span>:
                                        <?php
                                        $color_value = '';
                                        if ($commodites->color) {
                                            $color = get_color_type($commodites->color);
                                            if ($color) {
                                                $color_value .= $color->color_name;
                                            }
                                        }
                                        ?>
                                        <span><?php echo html_entity_decode($color_value); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($commodites->style_id) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('style_id'); ?></span>:
                                        <span><?php if ($commodites->style_id != null) {
                                                echo get_style_name(html_entity_decode($commodites->style_id)) != null ? get_style_name(html_entity_decode($commodites->style_id))->style_name : '';
                                            } else {
                                                echo '';
                                            } ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($commodites->rate) : ?>

                                    <li class="project-overview">
                                        <span class="fw-bold"><?php echo _l('price_without_tax'); ?></span>:
                                        <span><?php echo app_format_money((float)$commodites->rate, ''); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php if ($commodites->guarantee) : ?>
                                    <li class="project-overview">
                                        <span class="fw-bold td-width"><?php echo _l('guarantee_month'); ?></span>:
                                        <span><?php echo html_entity_decode($commodites->guarantee); ?></span>
                                    </li>
                                <?php endif; ?>
                                <?php
                                if ($custom_fields) {
                                    foreach ($custom_fields as $c) {
                                        if ($c['value']) {
                                            echo '<li class="project-overview">';
                                            echo '<span class="fw-bold td-width">' . $c['name'] . '</span>:';
                                            echo '<span>' . $c['value'] . '</span>';
                                            echo '</li>';
                                        }

                                    }
                                }

                                ?>
                            </ul>

                        </div>
                    </div>
                </div>


                <div class="col-md-12">
                    <div class="wrap_contents long_descriptions">
                        <?php
                        echo html_entity_decode($detailt_product->long_descriptions);
                        ?>
                    </div>
                    <div class="wrap_contents long_descriptions sub hide">
                    </div>
                    <br>
                </div>

            </div>

        </div>


    </div>


    <div class="wrapper row mbot25">
        <div class="service-inner bg-white w-100">
            <div class="panel-body">
                <div class="col-lg-3 col-sm-6 col-6 text-center">
                    <div tabindex="0" data-trigger="focus" class="single-item" data-container="body"
                            data-popover="popover" data-html="true" data-placement="top"
                            data-content="Retur garantat in maxim 14 zile de la cumparare. <br>Detalii <a href='https://www.figurine.ro/info/6-returnarea-produselor'>aici</a>"
                            data-original-title="" title="">
                        <div class="features-icon">
                            <i class="fas fa-undo"></i>
                        </div>
                        <div class="features-content">
                            <h5>Retur garantat</h5>
                            <p>14 zile, pentru comenzile online</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 col-6 text-center">
                    <div tabindex="0" data-trigger="focus" class="single-item" data-container="body"
                            data-popover="popover" data-html="true" data-placement="top"
                            data-content="Stii ce-ai comandat, verifica ce ai primit! Poti solicita curierului care iti face livrarea sa deschida coletul ca sa vezi daca produsele corespund descrierii de pe site. <br>Detalii <a href='https://www.figurine.ro/info/5-livrarea-produselor'>aici</a>"
                            data-original-title="" title="">
                        <div class="features-icon">
                            <i class="fas fa-box-full"></i>
                        </div>
                        <div class="features-content">
                            <h5>Verificare colet</h5>
                            <p>Deschiderea coletul la livrare</p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-sm-6 col-6 text-center">
                    <div tabindex="0" data-trigger="focus" class="single-item" data-container="body"
                            data-popover="popover" data-html="true" data-placement="top"
                            data-content="Nu este perceput nici un comision suplimentar pentru tranzactii cu cardul. <br>Detalii <a href='https://www.figurine.ro/info/4-cum-platesc'>aici</a>"
                            data-original-title="" title="">
                        <div class="features-icon">
                            <i class="fas fa-credit-card"></i>
                        </div>
                        <div class="features-content">
                            <h5>Plati securizate</h5>
                            <p>Online / Ramburs / OP</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6 col-6 text-center">
                    <div tabindex="0" data-trigger="focus" class="single-item" data-container="body"
                            data-popover="popover" data-html="true" data-placement="top"
                            data-content="Daca ai ales o alta modalitate de plata – card online, ordin de plata, plata in rate – termenul de livrare se poate modifica in functie de inregistrarea platii.. <br>Detalii <a href='https://www.figurine.ro/info/5-livrarea-produselor'>aici</a>"
                            data-original-title="" title="">
                        <div class="features-icon">
                            <i class="fas fa-shipping-fast"></i>
                        </div>
                        <div class="features-content">
                            <h5>Livrare rapida</h5>
                            <p>Produsele ajung in maxim 48h</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if (count($product) > 0) { ?>
        <div class="wrapper row">
            <div class="panel_s w-100">
                <div class="panel-body">
                    <h4 class="no-margin section-text"><?php echo _l('suggested_products'); ?></h4>
                </div>
                <div class="panel-body">
                    <div class="right-detail">
                        <div id="slidehind">
                            <div class="frame-slide">
                                <div class="frame" id="frameslide">
                                    <?php
                                    foreach ($product as $key => $item) { ?>
                                        <a href="<?php echo site_url('omni_sales/omni_sales_client/detailt/' . $item['id']); ?>">
                                            <?php
                                            $file_name = $this->omni_sales_model->get_image_file_name($item['id']);
                                            ?>
                                            <img src="<?php echo $this->omni_sales_model->get_image_items($item['id']); ?>">
                                            <div class="name"><?php echo html_entity_decode($item['name']); ?></div>
                                            <div class="price"><?php echo app_format_money($item['price'], $currency_name); ?></div>
                                        </a>
                                    <?php } ?>
                                </div>
                            </div>
                            <button class="btn btn-primary leftLst" onclick="scroll_slide(-1);"><i
                                        class="fa fa-chevron-left"></i>
                            </button>
                            <button class="btn btn-primary rightLst" onclick="scroll_slide(1);"><i
                                        class="fa fa-chevron-right"></i>
                            </button>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    <?php } ?>

    <?php if (isset($history_product) && !empty($history_product)) { ?>
        <div class="wrapper row">
            <div class="panel_s w-100">
                <div class="panel-body">
                    <h4 class="no-margin section-text"><?php echo _l('browsing_history'); ?></h4>
                </div>
                <div class="panel-body">

                    <?php if (count($history_product) > 0) { ?>
                        <div class="right-detail">
                            <div id="slidehind">
                                <div class="frame-slide p-0">
                                    <div class="frame h-unset p-5" id="frameslide">
                                        <?php
                                        foreach ($history_product as $key => $item) { ?>
                                            <a class="mt-0"
                                                    href="<?php echo site_url('omni_sales/omni_sales_client/detailt/' . $item['id']); ?>">
                                                <?php
                                                $file_name = $this->omni_sales_model->get_image_file_name($item['id']);
                                                ?>
                                                <img src="<?php echo $this->omni_sales_model->get_image_items($item['id']); ?>">
                                                <div class="name"><?php echo html_entity_decode($item['description']); ?></div>
                                            </a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>

    <div class="modal fade" id="alert_add" tabindex="-1" role="dialog">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-12 alert_content">
                            <div class="clearfix"></div>
                            <br>
                            <br>
                            <center class="add_success hide"><h4><?php echo _l('successfully_added'); ?></h4></center>
                            <center class="add_error hide">
                                <h4><?php echo _l('sorry_the_number_of_current_products_is_not_enough'); ?></h4>
                            </center>
                            <br>
                            <br>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" name="token_name"
            value="<?php echo html_entity_decode($this->security->get_csrf_token_name()); ?>">
    <input type="hidden" name="token_hash" value="<?php echo html_entity_decode($this->security->get_csrf_hash()); ?>">
<?php } else { ?>
    <br>
    <br>
    <br>
    <br>
    <center>
        <h4>
            <?php echo _l('data_does_not_exist'); ?>
        </h4>
    </center>

    <br>
    <div class="col-md-12 text-center">
        <a href="javascript:history.back()" class="btn btn-primary">
            <i class="fa fa-long-arrow-left" aria-hidden="true"></i> <?php echo _l('return_to_the_previous_page'); ?>
        </a>
    </div>
    </div>
<?php } ?>
<?php hooks()->do_action('client_pt_footer_js'); ?>

