<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Package - Pro
Version: 1.0.0
*/

define('PACKAGE_PRO', 'pro_package');

$CI = &get_instance();
/**
 * Register activation module hook
 */
register_activation_hook(PACKAGE_PRO, 'pro_activation_hook');
register_deactivation_hook(PACKAGE_PRO, 'pro_deactivation_hook');

function pro_activation_hook()
{
    require_once(__DIR__ . '/activate.php');
}
function pro_deactivation_hook()
{
  require(__DIR__ . '/deactivate.php');
}

hooks()->add_action('app_init', 'pro_init_package');
hooks()->add_action('admin_init', 'pro_init_menu_items');
hooks()->add_action('admin_init', 'pro_set_package');

hooks()->add_action('clients_init', 'pro_init_clients');




/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(PACKAGE_PRO, [PACKAGE_PRO]);

function pro_init_package(){
  $CI = &get_instance();
  $CI->app_acl->activate_staff();
  $CI->app_acl->activate_messages();
  $CI->app_acl->activate_sales();
  $CI->app_acl->activate_utilities();
  $CI->app_acl->activate_agenda();
  $CI->app_acl->activate_contracts();
  $CI->app_acl->custom_fields();
  $CI->app_acl->project_management();
  $CI->app_acl->marketing();
  $CI->app_acl->legal();
  $CI->app_acl->technical_support();
  $CI->app_acl->support();
  $CI->app_acl->finance();
  $CI->app_acl->reports();

  $CI->app_acl->remove_disabled_route([
    'admin/okr/report',
    'admin/commission/manage_commission',
    'admin/reports/sales',
    'admin/reports/expenses',
    'admin/reports/expenses_vs_income',
    'admin/reports/leads',
    'admin/team_password/report',
    'admin/resource_workload',
    'admin/staff/timesheets',
    'admin/reports/export_customer',
    'admin/reports/knowledge_base_articles',
    'leads'
  ]);

  //limit 2Gb pe utilities media

  //$CI->app_acl->do_blocked_routes();

}



function pro_init_clients(){
  pro_init_menu_items();
}
/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function pro_init_menu_items()
{
    $CI = &get_instance();
    if (is_admin()) {


    }
    $CI->app_menu->add_setup_children_item('staff', [
      'slug'=>'staff_sales_kpi_categories',
          'href'     => admin_url('sales_kpi_categories'),
          'name'     => _l('setup_menu_staff__kpi_categories'),
          'position' => 5,
      ]);


    $CI->app_menu->add_sidebar_menu_item('performance',[
        'name'     => _l('menu_performance'),
        'icon'     => 'fal fa-file-chart-pie',
        'position' => 150,
        'collapse' => true,
    ]);

    //$CI->app_acl->activate_itcorner();

//    if (!has_permission('commission', '', 'view') ){
//      $CI->app_menu->add_sidebar_menu_item('commissions-label',
//        [
//          'name'     => _l('menu_comissions'),
//          'icon'     => 'fal fa-money-check-edit-alt',
//          'href'     => admin_url('commission/manage_commission'),
//          'position' => 30,
//          'collapse' => true,
//        ]
//      );
//    }

    $CI->app_menu->add_sidebar_menu_item('purchase-invoice-label',
      [
        'name'     => _l('menu_purchase_invoice'),
        'icon'     => 'fa fa-crosshairs',
        'href'     => admin_url('commission/manage_commission'),
        'position' => 30,
        'collapse' => true,
      ]
    );


    /*$CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'ceo_strategic',
            'name'     => _l('menu_dashboard_ceo_strategic'),
            'position' => 1,
            'href'     => admin_url('dashboard/ceo'),
          ]
    );
    $CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'cmo_strategic',
        'name'     => _l('menu_dashboard_cmo_strategic'),
        'position' => 2,
         'href'     => admin_url('dashboard/cmo'),
      ]
    );
    $CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'dashboard_cfo',
        'name'     => _l('menu_dashboard_cfo'),
        'position' => 3,
        'href'     => admin_url('dashboard/cfo'),
      ]
    );*/
    /*$CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'sales_dashboard',
            'name'     => _l('menu_dashboard_sales'),
            'href' => admin_url('dashboard/sales_conversion'),
            'position' => 3,
        ]
    );*/


    /*$CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'dashboard_sales_kpi',
            'name'     => _l('menu_dashboard_sales_kpi'),
            'href' => admin_url('dashboard/sales_kpi'),
            'position' => 6,
        ]
    );
    $CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'dashboard_sales_cycle',
            'name'     => _l('menu_dashboard_sales_cycle'),
            'href' => admin_url('dashboard/sales_cycle'),
            'position' => 6,
        ]
    );*/

    /*$CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'operational_marketing',
        'name'     => _l('menu_dashboard_operational_marketing'),
        'href' => admin_url('dashboard/inbound_lead_generation'),
        'position' => 7,
      ]
    );*/
    /*$CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'client_services',
        'name'     => _l('menu_dashboard_helpdesk'),
        'href' => admin_url('dashboard/helpdesk'),
        'position' => 8,
      ]
    );
    $CI->app_menu->add_sidebar_children_item('dashboard',['slug'=>'tactical_finance',
        'name'     => _l('menu_dashboard_tactical_finance'),
        'href' => base_url('dashboard_sales_kpi/tactical_finance'),
        'position' => 9,
      ]
    );*/




    //pre($CI->app_acl->loaded_component);
}


function pro_set_package(){
  $CI = &get_instance();
  hooks()->do_action('package_loaded');
}


// return status book
if(!DEFINED('MEMBERS_INCLUDED')){
  DEFINE('MEMBERS_INCLUDED',14);
}
hooks()->add_filter('before_staff_status_change', 'pro_max_members', 10, 2);
function pro_max_members($status, $id){
  $CI = &get_instance();

  $max_active_members = MEMBERS_INCLUDED + (int)get_option('extra_seats');
  if((int)$status == 1){
    if((int)$CI->staff_model->count_active_members() >= $max_active_members AND $max_active_members != 0){
      return 0;
    }else{
      return 1;
    }
  }else{
    return 0;
  }


}
