<script>
    (function ($) {
        "use strict";
        validate_debit_note_form();
        // Init accountacy currency symbol
        init_currency();

        pur_calculate_total();

        <?php if(get_purchase_option('item_by_vendor') != 1){ ?>
        init_ajax_search('items', '#pur_item_select.ajax-search', undefined, admin_url + 'purchase/pur_commodity_code_search');
        <?php } ?>

        $('select[name="vendorid"]').on('change', function () {
            var vendor = $(this).val();
            if (vendor != '' && vendor != null && vendor != undefined) {
                requestGetJSON('purchase/vendor_change_data/' + vendor).done(function (response) {

                    for (var f in billingAndShippingFields) {
                        if (billingAndShippingFields[f].indexOf('billing') > -1) {
                            if (billingAndShippingFields[f].indexOf('country') > -1) {
                                $('select[name="' + billingAndShippingFields[f] + '"]').selectpicker('val', response['billing_shipping'][0][billingAndShippingFields[f]]);
                            } else {
                                if (billingAndShippingFields[f].indexOf('billing_street') > -1) {
                                    $('textarea[name="' + billingAndShippingFields[f] + '"]').val(response['billing_shipping'][0][billingAndShippingFields[f]]);
                                } else {
                                    $('input[name="' + billingAndShippingFields[f] + '"]').val(response['billing_shipping'][0][billingAndShippingFields[f]]);
                                }
                            }
                        }
                    }

                    if (!empty(response['billing_shipping'][0]['shipping_street'])) {
                        $('input[name="include_shipping"]').prop("checked", true).change();
                    }

                    for (var fsd in billingAndShippingFields) {
                        if (billingAndShippingFields[fsd].indexOf('shipping') > -1) {
                            if (billingAndShippingFields[fsd].indexOf('country') > -1) {
                                $('select[name="' + billingAndShippingFields[fsd] + '"]').selectpicker('val', response['billing_shipping'][0][billingAndShippingFields[fsd]]);
                            } else {
                                if (billingAndShippingFields[fsd].indexOf('shipping_street') > -1) {
                                    $('textarea[name="' + billingAndShippingFields[fsd] + '"]').val(response['billing_shipping'][0][billingAndShippingFields[fsd]]);
                                } else {
                                    $('input[name="' + billingAndShippingFields[fsd] + '"]').val(response['billing_shipping'][0][billingAndShippingFields[fsd]]);
                                }
                            }
                        }
                    }

                    init_billing_and_shipping_details();

                    var vendor_currency = response['vendor_currency'];
                    var s_currency = $("body").find('.accounting-template select[name="currency"]');
                    vendor_currency = parseInt(vendor_currency);
                    vendor_currency != 0 ? s_currency.val(vendor_currency) : s_currency.val(s_currency.data('base'));

                    s_currency.selectpicker('refresh');

                    <?php if(get_purchase_option('item_by_vendor') == 1){ ?>
                    if (response.option_html != '') {
                        $('#pur_item_select').html(response.option_html);
                        $('.selectpicker').selectpicker('refresh');
                    } else if (response.option_html == '') {
                        init_ajax_search('items', '#pur_item_select.ajax-search', undefined, admin_url + 'purchase/pur_commodity_code_search/purchase_price/can_be_purchased/' + invoker.value);
                    }

                    <?php } ?>


                    init_currency();
                });
            }
        });
    })(jQuery);

    function validate_debit_note_form(selector) {
        "use strict";
        selector = typeof (selector) == 'undefined' ? '#debit-note-form' : selector;

        appValidateForm($(selector), {
            vendorid: 'required',
            date: 'required',
            currency: 'required',
            number: {
                required: true,
            }
        });

        $("body").find('input[name="number"]').rules('add', {
            remote: {
                url: admin_url + "purchase/validate_debit_note_number",
                type: 'post',
                data: {
                    number: function () {
                        return $('input[name="number"]').val();
                    },
                    isedit: function () {
                        return $('input[name="number"]').data('isedit');
                    },
                    original_number: function () {
                        return $('input[name="number"]').data('original-number');
                    },
                    date: function () {
                        return $(".debit_note input[name='date']").val();
                    },
                }
            },
            messages: {
                remote: app.lang.debit_note_number_exists,
            }
        });
    }

    $("body").on('change', 'select[name="pur_item_select"]', function () {
        var itemid = $(this).selectpicker('val');
        if (itemid != '') {
            pur_add_item_to_preview(itemid);
        }
    });

    $("body").on('change', 'select.taxes', function () {
        pur_calculate_total();
    });

    function pur_add_item_to_preview(id) {
        "use strict";

        var currency_rate =  $('.currency_rate').val();

        requestGetJSON('purchase/get_item_by_id/' + id+'/'+ currency_rate ).done(function (response) {
           // clear_item_preview_values();

            $('.main input[name="item_code"]').val(response.itemid);
            $('.main textarea[name="description"]').val(response.code_description);
            $('.main textarea[name="long_description"]').val(response.long_description);
            $('.main input[name="unit_price"]').val(response.purchase_price);
            $('.main input[name="unit_name"]').val(response.unit_name);
            $('.main input[name="unit_id"]').val(response.unit_id);
            $('.main input[name="quantity"]').val(1);

            $('.selectpicker').selectpicker('refresh');


            var taxSelectedArray = [];
            if (response.taxname && response.taxrate) {
                taxSelectedArray.push(response.taxname + '|' + response.taxrate);
            }
            if (response.taxname_2 && response.taxrate_2) {
                taxSelectedArray.push(response.taxname_2 + '|' + response.taxrate_2);
            }

            $('.main select.taxes').selectpicker('val', taxSelectedArray);
            $('.main input[name="unit"]').val(response.unit_name);

            var $currency = $("body").find('.accounting-template select[name="currency"]');
            var baseCurency = $currency.attr('data-base');
            var selectedCurrency = $currency.find('option:selected').val();
            var $rateInputPreview = $('.main input[name="rate"]');

            if (baseCurency == selectedCurrency) {
                $rateInputPreview.val(response.purchase_price);
            } else {
                var itemCurrencyRate = response['rate_currency_' + selectedCurrency];
                if (!itemCurrencyRate || parseFloat(itemCurrencyRate) === 0) {
                    $rateInputPreview.val(response.purchase_price);
                } else {
                    $rateInputPreview.val(itemCurrencyRate);
                }
            }

            $(document).trigger({
                type: "item-added-to-preview",
                item: response,
                item_type: 'item',
            });
        });
    }

    var lastAddedItemKey = null;

    function pur_add_item_to_table(data, itemid) {
        "use strict";


        data = typeof (data) == 'undefined' || data == 'undefined' ? pur_get_item_preview_values() : data;
        if (data.quantity == "" ||  data.item_name == "" ||  data.unit_price == "") {
            alert_float('warning', "<?php echo _l('please_fill_fields'); ?> (<?php echo _l('pur_item_name'); ?> , <?php echo _l('quantity'); ?> , <?php echo _l('unit_price'); ?>)" )
            return;
        }
        var currency_rate = $('input[name="currency_rate"]').val();
        var to_currency = $('select[name="currency"]').val();
        var table_row = '';
        var item_key = lastAddedItemKey ? lastAddedItemKey += 1 : $("body").find('.credite-note-items-table tbody .item').length + 1;
        lastAddedItemKey = item_key;
        $("body").append('<div class="dt-loader"></div>');
        pur_get_item_row_template('newitems[' + item_key + ']',data.item_name, data.description, data.quantity, data.unit_name, data.unit_price, data.taxname, data.item_code, data.unit_id, data.tax_rate, data.discount, itemid, currency_rate, to_currency).done(function(output){
            table_row += output;

            $('.invoice-item table.credite-note-items-table.items tbody').append(table_row);

            setTimeout(function () {
                pur_calculate_total();
            }, 15);
            init_selectpicker();
            pur_reorder_items('.invoice-item');
            pur_clear_item_preview_values('.invoice-item');
            $('body').find('#items-warning').remove();
            $("body").find('.dt-loader').remove();
            $('#pur_item_select').selectpicker('val', '');

            return true;
        });
        return false;
    }

    function pur_get_item_preview_values() {
        "use strict";

        var response = {};
        response.item_name = $('.invoice-item .main input[name="item_name"]').val();
        response.description = $('.invoice-item .main textarea[name="description"]').val();
        response.quantity = $('.invoice-item .main input[name="quantity"]').val();
        response.unit_name = $('.invoice-item .main input[name="unit_name"]').val();
        response.unit_price = $('.invoice-item .main input[name="unit_price"]').val();
        response.taxname = $('.main select.taxes').selectpicker('val');
        response.item_code = $('.invoice-item .main input[name="item_code"]').val();
        response.unit_id = $('.invoice-item .main input[name="unit_id"]').val();
        response.tax_rate = $('.invoice-item .main input[name="tax_rate"]').val();
        response.discount = $('.invoice-item .main input[name="discount"]').val();


        return response;
    }


    function pur_clear_item_preview_values(parent) {
        "use strict";

        var previewArea = $(parent + ' .main');
        previewArea.find('input').val('');
        previewArea.find('textarea').val('');
        previewArea.find('select').val('').selectpicker('refresh');
    }

    function pur_get_item_row_template(name, item_name, description, quantity, unit_name, unit_price, taxname,  item_code, unit_id, tax_rate, discount, item_key, currency_rate, to_currency)  {
        "use strict";

        jQuery.ajaxSetup({
            async: false
        });

        var d = $.post(admin_url + 'purchase/get_purchase_invoice_row_template', {
            name: name,
            item_name : item_name,
            item_description : description,
            quantity : quantity,
            unit_name : unit_name,
            unit_price : unit_price,
            taxname : taxname,
            item_code : item_code,
            unit_id : unit_id,
            tax_rate : tax_rate,
            discount : discount,
            item_key : item_key,
            currency_rate: currency_rate,
            to_currency: to_currency
        });
        jQuery.ajaxSetup({
            async: true
        });
        return d;
    }


    function pur_calculate_total(from_discount_money) {
        "use strict";
        if ($('body').hasClass('no-calculate-total')) {
            return false;
        }

        var calculated_tax,
            taxrate,
            item_taxes,
            row,
            _amount,
            _tax_name,
            taxes = {},
            taxes_rows = [],
            subtotal = 0,
            total = 0,
            total_money = 0,
            total_tax_money = 0,
            quantity = 1,
            total_discount_calculated = 0,
            item_discount_percent = 0,
            item_discount_money = 0,
            item_discount_from_percent = 0,
            item_discount = 0,
            item_total_payment,
            rows = $('.table.has-calculations tbody tr.item'),
            subtotal_area = $('#subtotal'),
            discount_area = $('#discount_area'),
            adjustment = $('input[name="adjustment"]').val(),
            // discount_percent = $('input[name="discount_percent"]').val(),
            discount_percent = 'before_tax',
            discount_fixed = $('input[name="discount_total"]').val(),
            discount_total_type = $('.discount-total-type.selected'),
            discount_type = $('select[name="discount_type"]').val(),
            additional_discount = $('input[name="additional_discount"]').val();

        var shipping_fee = $('input[name="shipping_fee"]').val();
        if (shipping_fee == '') {
            shipping_fee = 0;
            $('input[name="shipping_fee"]').val(0);
        }

        $('.wh-tax-area').remove();

        $.each(rows, function () {

            var item_tax = 0,
                item_amount = 0;

            quantity = $(this).find('[data-quantity]').val();
            if (quantity === '') {
                quantity = 1;
                $(this).find('[data-quantity]').val(1);
            }
            item_discount_percent = $(this).find('td.discount input').val();
            item_discount_money = $(this).find('td.discount_money input').val();

            if (isNaN(item_discount_percent) || item_discount_percent == '') {
                item_discount_percent = 0;
            }

            if (isNaN(item_discount_money) || item_discount_money == '') {
                item_discount_money = 0;
            }

            if (from_discount_money == 1 && item_discount_money > 0) {
                $(this).find('td.discount input').val('');
            }

            _amount = accounting.toFixed($(this).find('td.rate input').val() * quantity, app.options.decimal_places);
            item_amount = _amount;
            _amount = parseFloat(_amount);

            $(this).find('td.into_money').html(format_money(_amount));
            $(this).find('td._into_money input').val(_amount);

            subtotal += _amount;
            row = $(this);
            item_taxes = $(this).find('select.taxes').val();

            if (item_taxes) {
                $.each(item_taxes, function (i, taxname) {
                    taxrate = row.find('select.taxes [value="' + taxname + '"]').data('taxrate');
                    calculated_tax = (_amount / 100 * taxrate);
                    item_tax += calculated_tax;
                    if (!taxes.hasOwnProperty(taxname)) {
                        if (taxrate != 0) {
                            _tax_name = taxname.split('|');
                            var tax_row = '<tr class="wh-tax-area"><td>' + _tax_name[0] + '(' + taxrate + '%)</td><td id="tax_id_' + slugify(taxname) + '"></td></tr>';
                            $(subtotal_area).after(tax_row);
                            taxes[taxname] = calculated_tax;
                        }
                    } else {
                        // Increment total from this tax
                        taxes[taxname] = taxes[taxname] += calculated_tax;
                    }
                });
            }
            var after_tax = _amount + item_tax;

            $(this).find('td._total').html(format_money(after_tax));
            $(this).find('td._total_after_tax input').val(after_tax);

            $(this).find('td.tax_value input').val(item_tax);
            //Discount of item
            if (item_discount_percent > 0 && from_discount_money != 1) {
                item_discount_from_percent = (parseFloat(item_amount) + parseFloat(item_tax)) * parseFloat(item_discount_percent) / 100;
                if (item_discount_from_percent != item_discount_money) {
                    item_discount_money = item_discount_from_percent;
                }
            }

            if (item_discount_money > 0) {
                item_discount = parseFloat(item_discount_money);
            }

            item_total_payment = parseFloat(item_amount) + parseFloat(item_tax) - parseFloat(item_discount);

            // Append value to item
            total_discount_calculated += item_discount;
            $(this).find('td.discount_money input').val(item_discount);
            $(this).find('td.total_after_discount input').val(item_total_payment);

            $(this).find('td.label_discount_money').html(format_money(item_discount));
            $(this).find('td.label_total_after_discount').html(format_money(item_total_payment));

        });

        // Discount by percent
        if ((discount_percent !== '' && discount_percent != 0) && discount_type == 'before_tax' && discount_total_type.hasClass('discount-type-percent')) {
            total_discount_calculated = (subtotal * discount_percent) / 100;
        } else if ((discount_fixed !== '' && discount_fixed != 0) && discount_type == 'before_tax' && discount_total_type.hasClass('discount-type-fixed')) {
            total_discount_calculated = discount_fixed;
        }

        $.each(taxes, function (taxname, total_tax) {
            if ((discount_percent !== '' && discount_percent != 0) && discount_type == 'before_tax' && discount_total_type.hasClass('discount-type-percent')) {
                total_tax_calculated = (total_tax * discount_percent) / 100;
                total_tax = (total_tax - total_tax_calculated);
            } else if ((discount_fixed !== '' && discount_fixed != 0) && discount_type == 'before_tax' && discount_total_type.hasClass('discount-type-fixed')) {
                var t = (discount_fixed / subtotal) * 100;
                total_tax = (total_tax - (total_tax * t) / 100);
            }

            total += total_tax;
            total_tax_money += total_tax;
            total_tax = format_money(total_tax);
            $('#tax_id_' + slugify(taxname)).html(total_tax);
        });


        total = (total + subtotal);
        total_money = total;
        // Discount by percent
        if ((discount_percent !== '' && discount_percent != 0) && discount_type == 'after_tax' && discount_total_type.hasClass('discount-type-percent')) {
            total_discount_calculated = (total * discount_percent) / 100;
        } else if ((discount_fixed !== '' && discount_fixed != 0) && discount_type == 'after_tax' && discount_total_type.hasClass('discount-type-fixed')) {
            total_discount_calculated = discount_fixed;
        }

        total = total - total_discount_calculated - parseFloat(additional_discount);
        adjustment = parseFloat(adjustment);

        // Check if adjustment not empty
        if (!isNaN(adjustment)) {
            total = total + adjustment;
        }

        total += parseFloat(shipping_fee);

        var discount_html = '-' + format_money(parseFloat(total_discount_calculated) + parseFloat(additional_discount));
        $('input[name="discount_total"]').val(accounting.toFixed(total_discount_calculated, app.options.decimal_places));

        // Append, format to html and display
        $('.shiping_fee').html(format_money(shipping_fee));
        $('.wh-total_discount').html(discount_html + hidden_input('dc_total', accounting.toFixed(total_discount_calculated, app.options.decimal_places)));
        $('.adjustment').html(format_money(adjustment));
        $('.wh-subtotal').html(format_money(subtotal) + hidden_input('total_mn', accounting.toFixed(subtotal, app.options.decimal_places)));
        $('.wh-total').html(format_money(total) + hidden_input('grand_total', accounting.toFixed(total, app.options.decimal_places)));

        $(document).trigger('purchase-quotation-total-calculated');

    }


</script>