<script>
(function($) {
  "use strict";
	var greetDate = new Date();
	var hrsGreet = greetDate.getHours();

	var greet;
	if (hrsGreet < 12)
		greet = "<?php echo _l('good_morning'); ?>";
	else if (hrsGreet >= 12 && hrsGreet <= 17)
		greet = "<?php echo _l('good_afternoon'); ?>";
	else if (hrsGreet >= 17 && hrsGreet <= 24)
		greet = "<?php echo _l('good_evening'); ?>";

	if(greet) {
		document.getElementById('greeting').innerHTML =
		'<b>' + greet + ' <?php echo html_entity_decode($contact->firstname); ?>!</b>';
	}
})(jQuery);

if ( $( "#get-anaf" ).length ) {
    document.getElementById('get-anaf').addEventListener('click',function(e){
        // $(document).on('click', '#get-anaf', function (e) {
        e.preventDefault();
        var vat_number = $(this).closest('.input-group').find('input[name="vat"]').val();

        // Remove spaces from vat_number
        vat_number = vat_number.replace(/\s/g, '');

        // Now vat_number does not contain spaces
        if(vat_number.length) {
            $.ajax({
                method: 'get',
                url: admin_url + 'clients/get_anaf/' + vat_number,
                dataType: 'json',
                success: function (json) {
                    if (json === undefined || json === null) {
                        alert_float('danger', json.message);
                    } else {
                        if (json.type) {
                            alert_float('success', json.message);
                            if (typeof json.denumire !== 'undefined') {
                                $('#company').val(json.denumire);
                            }
                            if (typeof json.adresa !== 'undefined' && typeof json.adresa.raw !== 'undefined') {
                                $('#address').val(json['adresa']['raw']);
                            }
                            if (typeof json.adresa !== 'undefined' && typeof json.adresa.judet !== 'undefined') {
                                $('#state').val(json['adresa']['judet']);
                            }
                            if (typeof json.adresa !== 'undefined' && typeof json.adresa.localitate !== 'undefined') {
                                $('#city').val(json['adresa']['judet']);
                            }
                            if (typeof json.iban !== 'undefined' && typeof json.iban !== 'undefined') {
                                //$('#iban').val(json['iban']);
                            }

                            if (typeof json.telefon !== 'undefined') {
                                $('#phonenumber').val(json['telefon']);
                            }
                            if (typeof json.nrRegCom !== 'undefined') {
                                $('#trade_number').val(json['nrRegCom']);
                            }


                            if (typeof json.hasTVA !== 'undefined') {
                                if (json['hasTVA']) {
                                    $('#is_vat_yes').prop('checked', true);
                                } else {
                                    $('#is_vat_no').prop('checked', false);
                                }
                            } else {
                                $('#is_vat_no').prop('checked', false);
                            }
                        } else {
                            if (json.message.length)
                                alert_float('danger', json.message);
                        }
                    }


                }
            });
        } else {
            alert_float('warning', '<?= _l('error_cif_field'); ?>');
            $(this).closest('.input-group').find('input').focus();
            $(this).closest('.input-group').addClass('has-error');
        }
    });
}

</script>
