<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Purchase_contract_merge_fields extends App_merge_fields
{
    public function build()
    {
        return [
            [
                'name'      => 'Contract ID',
                'key'       => '{contract_id}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Contract number',
                'key'       => '{contract_number}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Contract name',
                'key'       => '{contract_name}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Service category',
                'key'       => '{contract_service_category}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Payment terms',
                'key'       => '{contract_payment_terms}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Contract Date Start',
                'key'       => '{contract_datestart}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Contract Date End',
                'key'       => '{contract_dateend}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Contract Value',
                'key'       => '{contract_contract_value}',
                'available' => [
                    'purchase_contract',
                ],
            ],
            [
                'name'      => 'Project name',
                'key'       => '{project_name}',
                'available' => [
                    'purchase_contract',
                ],
            ],
        ];
    }

    /**
     * Merge field for contracts
     * @param  mixed $contract_id contract id
     * @return array
     */
    public function format($contract_id)
    {
        $fields = [];
        $this->ci->db->where('id', $contract_id);
        $contract = $this->ci->db->get(db_prefix().'pur_contracts')->row();

        if (!$contract) {
            return $fields;
        }

        $currency = get_base_currency();
        $fields['{contract_id}']             = $contract->id;
        $fields['{contract_number}']           = $contract->contract_number;
        $fields['{contract_name}']           = $contract->contract_name;
        $fields['{contract_service_category}']           = $contract->service_category;
        $fields['{contract_datestart}']      = _d($contract->start_date);
        $fields['{contract_dateend}']        = _d($contract->end_date);
        $fields['{contract_payment_terms}']           = $contract->payment_terms;
        $fields['{contract_payment_amount}']           = $contract->payment_amount;
        $fields['{contract_contract_value}'] = app_format_money($contract->contract_value, $currency);
        $fields['{project_name}']    = get_project_name_by_id($contract->project);

        return hooks()->apply_filters('contract_merge_fields', $fields, [
            'id'       => $contract_id,
            'contract' => $contract,
        ]);
    }
}
