<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal fade" id="purchase-category-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <?php echo form_open(admin_url('purchase/category'),array('id'=>'purchase-category-form')); ?>
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">
                    <span class="edit-title"><?php echo _l('edit_purchase_category'); ?></span>
                    <span class="add-title"><?php echo _l('new_purchase_category'); ?></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div id="additional"></div>
                        <div class="form-group" app-field-wrapper="parent_id">
                            <label for="parent_id" class="control-label"> <small class="req text-danger">* </small><?php echo _l('purchase_add_edit_parent'); ?></label>
                            <?php echo $categories; ?>
                        </div>

                        <?php echo render_input('name','purchase_add_edit_name'); ?>
                        <?php echo render_textarea('description','purchase_add_edit_description'); ?>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo _l('close'); ?></button>
                <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
            </div>
        </div><!-- /.modal-content -->
        <?php echo form_close(); ?>
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->
<script>
    window.addEventListener('load',function(){
        appValidateForm($('#purchase-category-form'),{name:'required' , parent_id:'required'},manage_categories);
        $('#purchase-category-modal').on('hidden.bs.modal', function(event) {
            $('#additional').html('');
            $('#purchase-category-modal input[name="name"]').val('');
            $('#purchase-category-modal textarea').val('');
            $('.add-title').removeClass('hide');
            $('.edit-title').removeClass('hide');
        });
    });
    function manage_categories(form) {
        var data = $(form).serialize();
        var url = form.action;
        $.post(url, data).done(function(response) {
            response = JSON.parse(response);

            if(response.success == true){
                alert_float('success',response.message);
                if($('body').hasClass('purchase') && typeof(response.id) != 'undefined') {
                    var category = $('#category');
                    category.find('option:first').after('<option value="'+response.id+'">'+response.name+'</option>');
                    category.selectpicker('val',response.id);
                    category.selectpicker('refresh');
                }
            }

            if($.fn.DataTable.isDataTable('.table-purchase-categories')){
                $('.table-purchase-categories').DataTable().ajax.reload();
            }

            $('#purchase-category-modal').modal('hide');
        });
        return false;
    }

    function new_category(){
        $('#purchase-category-modal').modal('show');
        $('.edit-title').addClass('hide');
    }

    function edit_category(invoker,id){
        var name = $(invoker).data('name');
        var description = $(invoker).data('description');
        var parent = $(invoker).data('parent');
        $('#additional').append(hidden_input('id',id));
        $("#purchase-category-modal select option[value="+parent+"]").prop("selected", "selected")
        $('#purchase-category-modal input[name="name"]').val(name);
        $('#purchase-category-modal textarea').val(description);
        $('#purchase-category-modal').modal('show');
        $('.add-title').addClass('hide');
    }
</script>
