<?php

defined('BASEPATH') or exit('No direct script access allowed');


$aColumns = [
    'pur_order_number',
    'order_date',
    'vendor',
    'subtotal',
    'total_tax',
    'delivery_date',
    'delivery_status',
];


$base_currency = get_base_currency_pur();

$sIndexColumn = 'id';
$sTable = db_prefix() . 'pur_orders';
$join = [
    'LEFT JOIN ' . db_prefix() . 'pur_vendor ON ' . db_prefix() . 'pur_vendor.userid = ' . db_prefix() . 'pur_orders.vendor',
];
$i = 0;


$where = [];

array_push($where, 'AND ((delivery_date >= "' . date('Y-m-d') . '" AND delivery_date <= "' . date('Y-m-d', strtotime('+7 day', strtotime(date('Y-m-d')))) . '" ) OR delivery_status IN (0,2,3))');

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [db_prefix() . 'pur_orders.id as id', 'company', 'pur_order_number', 'expense_convert', 'number']);

$output = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $row = [];

    for ($i = 0; $i < count($aColumns); $i++) {
        if (strpos($aColumns[$i], 'as') !== false && !isset($aRow[$aColumns[$i]])) {
            $_data = $aRow[strafter($aColumns[$i], 'as ')];
        } else {
            $_data = $aRow[$aColumns[$i]];
        }

        if ($aColumns[$i] == 'pur_order_number') {

            $numberOutput = '';

            $numberOutput = '<a href="' . admin_url('purchase/purchase_order/' . $aRow['id']) . '"  onclick="init_pur_order(' . $aRow['id'] . '); return false;" >' . $aRow['pur_order_number'] . '</a>';


            $_data = $numberOutput;

        } elseif ($aColumns[$i] == 'vendor') {
            $_data = '<a href="' . admin_url('purchase/vendor/' . $aRow['vendor']) . '" >' . $aRow['company'] . '</a>';
        } elseif ($aColumns[$i] == 'order_date') {
            $_data = _d($aRow['order_date']);
        } elseif ($aColumns[$i] == 'total_tax') {
            $_data = app_format_money($aRow['total_tax'], $base_currency->symbol);
        } elseif ($aColumns[$i] == 'subtotal') {
            $_data = app_format_money($aRow['subtotal'], $base_currency->symbol);
        } elseif ($aColumns[$i] == 'delivery_status') {
            $delivery_status = '';

            if ($aRow['delivery_status'] == 0) {
                $delivery_status = '<span class="inline-block label label-danger" id="status_span_' . $aRow['id'] . '" task-status-table="undelivered">' . _l('undelivered');
            } else if ($aRow['delivery_status'] == 1) {
                $delivery_status = '<span class="inline-block label label-success" id="status_span_' . $aRow['id'] . '" task-status-table="completely_delivered">' . _l('completely_delivered');
            } else if ($aRow['delivery_status'] == 2) {
                $delivery_status = '<span class="inline-block label label-info" id="status_span_' . $aRow['id'] . '" task-status-table="pending_delivered">' . _l('pending_delivered');
            } else if ($aRow['delivery_status'] == 3) {
                $delivery_status = '<span class="inline-block label label-warning" id="status_span_' . $aRow['id'] . '" task-status-table="partially_delivered">' . _l('partially_delivered');
            }


            $delivery_status .= '</span>';
            $_data = $delivery_status;
        } elseif ($aColumns[$i] == 'delivery_date') {
            $_data = _d($aRow['delivery_date']);
        }

        $row[] = $_data;
    }
    $output['aaData'][] = $row;

}
