<?php
defined('BASEPATH') or exit('No direct script access allowed');

add_option('recruitment_create_campaign_with_plan',1);

if (!$CI->db->table_exists(db_prefix() . 'rec_job_position')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_job_position` (
      `position_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `position_name` varchar(200) NOT NULL,
      `position_description` text NULL,
      PRIMARY KEY (`position_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_proposal')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_proposal` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `proposal_name` varchar(200) NOT NULL,
      `position` int(11) NOT NULL,
      `department` int(11) NULL,
      `amount_recruiment` int(11) NULL,
      `form_work` varchar(45) NULL,
      `workplace` varchar(255) NULL,
      `salary_from` DECIMAL(15,0) NULL,
      `salary_to` DECIMAL(15,0) NULL,
      `from_date` date NULL,
      `to_date` date NOT NULL,
      `reason_recruitment` text NULL,
      `job_description` text NULL,
      `approver` int(11) NOT NULL,
      `ages_from` int(11) NULL,
      `ages_to` int(11) NULL,
      `gender` varchar(10) NULL,
      `height` float NULL,
      `weight` float NULL,
      `literacy` varchar(200) NULL,
      `experience` varchar(200) NULL,
      `add_from` int(11) NOT NULL,
      `date_add` date NOT NULL,
      `status` int(11) NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_campaign')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_campaign` (
      `cp_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `campaign_code` varchar(200) NOT NULL,
      `campaign_name` varchar(200) NOT NULL,
      `cp_proposal` text NULL,
      `cp_position` int(11) NOT NULL,
      `cp_department` int(11) NULL,
      `cp_amount_recruiment` int(11) NULL,
      `cp_form_work` varchar(45) NULL,
      `cp_workplace` varchar(255) NULL,
      `cp_salary_from` DECIMAL(15,0) NULL,
      `cp_salary_to` DECIMAL(15,0) NULL,
      `cp_from_date` date NULL,
      `cp_to_date` date NOT NULL,
      `cp_reason_recruitment` text NULL,
      `cp_job_description` text NULL,
      `cp_manager` text NULL,
      `cp_follower` text NULL,
      `cp_ages_from` int(11) NULL,
      `cp_ages_to` int(11) NULL,
      `cp_gender` varchar(10) NULL,
      `cp_height` float NULL,
      `cp_weight` float NULL,
      `cp_literacy` varchar(200) NULL,
      `cp_experience` varchar(200) NULL,
      `cp_add_from` int(11) NOT NULL,
      `cp_date_add` date NOT NULL,
      `cp_status` int(11) NOT NULL,
      PRIMARY KEY (`cp_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_candidate')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_candidate` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `rec_campaign` int(11) NULL,
      `candidate_code` varchar(200) NOT NULL,
      `candidate_name` varchar(200) NOT NULL,
      `birthday` date NULL,
      `gender` varchar(11) NULL,
      `birthplace` text NULL,
      `home_town` text NULL,
      `identification` varchar(45) NULL,
      `days_for_identity` date NULL,
      `place_of_issue` varchar(255) NULL,
      `marital_status` varchar(11) NULL,
      `nationality` varchar(100) NULL,
      `nation` varchar(100) NOT NULL,
      `religion` varchar(100) NULL,
      `height` float NULL,
      `weight` float NULL,
      `introduce_yourself` text NULL,
      `phonenumber` int(15) NULL,
      `email` text NULL,
      `skype` text NULL,
      `facebook` text NULL,
      `resident` text NULL,
      `current_accommodation` text NULL,
      `status` int(11) NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->field_exists('date_add', db_prefix() . 'rec_candidate')) {
    $CI->db->query('ALTER TABLE `' . db_prefix() . "rec_candidate`
    ADD COLUMN `date_add` DATE NULL AFTER `status`
  ;");
}

if (!$CI->db->field_exists('desired_salary', db_prefix() . 'rec_candidate')) {
    $CI->db->query('ALTER TABLE `' . db_prefix() . "rec_candidate`
    ADD COLUMN `desired_salary` DATE NULL AFTER `status`
  ;");
}

if (!$CI->db->field_exists('rate', db_prefix() . 'rec_candidate')) {
    $CI->db->query('ALTER TABLE `' . db_prefix() . "rec_candidate`
    ADD COLUMN `rate` int(11) NULL AFTER `status`
  ;");
}

if (!$CI->db->table_exists(db_prefix() . 'cd_work_experience')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "cd_work_experience` (
      `we_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `candidate` int(11) NOT NULL,
      `from_date` date NULL,
      `to_date` date NULL,
      `company` varchar(200) NULL,
      `position` varchar(200) NULL,
      `contact_person` varchar(200) NULL,
      `salary` varchar(200) NULL,
      `reason_quitwork` varchar(200) NULL,
      `job_description` varchar(200) NULL,
      PRIMARY KEY (`we_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'cd_literacy')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "cd_literacy` (
      `li_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `candidate` int(11) NOT NULL,
      `literacy_from_date` date NULL,
      `literacy_to_date` date NULL,
      `diploma` varchar(200) NULL,
      `training_places` varchar(200) NULL,
      `specialized` varchar(200) NULL,
      `training_form` varchar(200) NULL,
      PRIMARY KEY (`li_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'cd_family_infor')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "cd_family_infor` (
      `fi_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `candidate` int(11) NOT NULL,
      `relationship` varchar(100) NULL,
      `name` varchar(200) NULL,
      `fi_birthday` date NULL,
      `job` varchar(200) NULL,
      `address` varchar(200) NULL,
      `phone` int(15) NULL,
      PRIMARY KEY (`fi_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_interview')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_interview` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `campaign` int(11) NOT NULL,
      `is_name` varchar(100) NOT NULL,
      `interview_day` varchar(200) NOT NULL,
      `from_time` text NOT NULL,
      `to_time` text NOT NULL,
      `from_hours` datetime NULL,
      `to_hours` datetime NULL,
      `interviewer` text NOT NULL,
      `added_from` int(11) NOT NULL,
      `added_date` date NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'cd_interview')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "cd_interview` (
      `in_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `candidate` int(11) NOT NULL,
      `interview` int(11) NOT NULL,
      PRIMARY KEY (`in_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'cd_care')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "cd_care` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `candidate` int(11) NOT NULL,
      `care_time` datetime NOT NULL,
      `care_result` text NOT NULL,
      `description` text NULL,
      `add_from` int(11) NOT NULL,
      `add_time` datetime NULL,
      `type` varchar(45) NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}


if (!$CI->db->table_exists(db_prefix() . 'rec_criteria')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_criteria` (
      `criteria_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `criteria_type` varchar(45) NOT NULL,
      `criteria_title` varchar(200) NOT NULL,
      `group_criteria` int(11)  NULL,
      `description` text NULL,
      `add_from` int(11) NOT NULL,
      `add_date` date NULL,
      `score_des1` text NULL,
      `score_des2` text NULL,
      `score_des3` text NULL,
      `score_des4` text NULL,
      `score_des5` text NULL,
      PRIMARY KEY (`criteria_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_evaluation_form')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_evaluation_form` (
      `form_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `form_name` varchar(200) NOT NULL,
      `position` int(11) NULL,
      `add_from` int(11) NOT NULL,
      `add_date` date NULL,
      PRIMARY KEY (`form_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_list_criteria')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_list_criteria` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `evaluation_form` int(11) NOT NULL,
      `group_criteria` int(11) NOT NULL,
      `evaluation_criteria` int(11) NOT NULL,
      `percent` float NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_cd_evaluation')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_cd_evaluation` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `criteria` int(11) NOT NULL,
      `rate_score` int(11) NOT NULL,
      `assessor` int(11) NOT NULL,
      `evaluation_date` datetime NOT NULL,
      `percent` int(11) NOT NULL,
      `candidate` int(11) NOT NULL,
      `feedback` TEXT NOT NULL,
      `group_criteria` int(11) NOT NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_set_transfer_record')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_set_transfer_record` (
      `set_id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `send_to` varchar(45) NOT NULL,
      `email_to` text NULL,
      `add_from` int(11) NOT NULL,
      `add_date` date NOT NULL,
      `subject` text NOT NULL,
      `content` text NULL,
      PRIMARY KEY (`set_id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}
if (!$CI->db->field_exists('order', db_prefix() . 'rec_set_transfer_record')) {
    $CI->db->query('ALTER TABLE `' . db_prefix() . "rec_set_transfer_record`
    ADD COLUMN `order` int(11) NOT NULL AFTER `set_id`
  ;");
}

if (!$CI->db->table_exists(db_prefix() . 'rec_campaign_form_web')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_campaign_form_web` (
     `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
     `rec_campaign_id` int(11) NOT NULL,
     `form_type` int(11) NULL,
     `lead_source` varchar(10) NULL,
      `lead_status` varchar(10) NULL,
      `notify_ids_staff` text NULL,
      `notify_ids_roles` text NULL,
      `form_key` varchar(32) NULL,
      `notify_lead_imported` int(11) NULL DEFAULT '1',
      `notify_type` varchar(20) DEFAULT NULL,
      `notify_ids` mediumtext,
      `responsible` int(11) NULL DEFAULT '0',
      `name` varchar(191) NULL,
      `form_data` mediumtext,
      `recaptcha` int(11) NULL DEFAULT '0',
      `submit_btn_name` varchar(40) DEFAULT NULL,
      `success_submit_msg` text,
      `language` varchar(40) DEFAULT NULL,
      `allow_duplicate` int(11) NULL DEFAULT '1',
      `mark_public` int(11) NULL DEFAULT '0',
      `track_duplicate_field` varchar(20) DEFAULT NULL,
      `track_duplicate_field_and` varchar(20) DEFAULT NULL,
      `create_task_on_duplicate` int(11) NULL DEFAULT '0',
    PRIMARY KEY (`id`, `rec_campaign_id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}
if (!$CI->db->table_exists(db_prefix() . 'web_to_recruitment')) {
    $CI->db->query('CREATE TABLE `' . db_prefix()."web_to_recruitment` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `campaign_code` varchar(200) NULL,
      `campaign_name` varchar(200) NULL,
      `cp_proposal` text NULL,
      `cp_position` int(11) NULL,
      `cp_department` int(11) NULL,
      `cp_amount_recruiment` int(11) NULL,
      `cp_form_work` varchar(45) NULL,
      `cp_workplace` varchar(255) NULL,
      `cp_salary_from` DECIMAL(15,0) NULL,
      `cp_salary_to` DECIMAL(15,0) NULL,
      `cp_from_date` date NULL,
      `cp_to_date` date NULL,
      `cp_reason_recruitment` text NULL,
      `cp_job_description` text NULL,
      `cp_manager` text NULL,
      `cp_follower` text NULL,
      `cp_ages_from` int(11) NULL,
      `cp_ages_to` int(11) NULL,
      `cp_gender` varchar(10) NULL,
      `cp_height` float NULL,
      `cp_weight` float NULL,
      `cp_literacy` varchar(200) NULL,
      `cp_experience` varchar(200) NULL,
      `cp_add_from` int(11) NULL,
      `cp_date_add` date NULL,
      `cp_status` int(11) NULL,
      `nation` varchar(15),
      `nationality` varchar(15),
      `religion` varchar(15),
      `marital_status` varchar(15),
      `birthplace` varchar(200),
      `home_town` varchar(200),
      `resident` varchar(200),
      `current_accommodation` varchar(200),
      `cp_desired_salary` varchar(10) NULL,
      `specialized` varchar(100),
      `training_form` varchar(50),
      `training_places` varchar(50),

      `lead_source` varchar(10) NULL,
      `lead_status` varchar(10) NULL,
      `notify_ids_staff` text NULL,
      `notify_ids_roles` text NULL,
      `form_key` varchar(32) NULL,
      `notify_lead_imported` int(11) NULL DEFAULT '1',
      `notify_type` varchar(20) DEFAULT NULL,
      `notify_ids` mediumtext,
      `responsible` int(11) NULL DEFAULT '0',
      `name` varchar(191) NULL,
      `form_data` mediumtext,
      `recaptcha` int(11) NULL DEFAULT '0',
      `submit_btn_name` varchar(40) DEFAULT NULL,
      `success_submit_msg` text,
      `language` varchar(40) DEFAULT NULL,
      `allow_duplicate` int(11) NULL DEFAULT '1',
      `mark_public` int(11) NULL DEFAULT '0',
      `track_duplicate_field` varchar(20) DEFAULT NULL,
      `track_duplicate_field_and` varchar(20) DEFAULT NULL,
      `create_task_on_duplicate` int(11) NULL DEFAULT '0',
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
  //previously, demo data
}

if ($CI->db->field_exists('name', db_prefix() . 'rec_campaign_form_web')) {
    $CI->db->query('ALTER TABLE `' . db_prefix() . "rec_campaign_form_web`
    CHANGE COLUMN `name` `r_form_name` VARCHAR(191) NULL
  ;");
}


if (!$CI->db->field_exists('recruitment_channel', db_prefix() . 'rec_candidate')) {
    $CI->db->query('ALTER TABLE `' . db_prefix() . "rec_candidate`
    ADD COLUMN `recruitment_channel` int(11) NULL AFTER `date_add`
  ;");
}
$CI->db->query('ALTER TABLE `' . db_prefix() . "rec_candidate`
    CHANGE COLUMN `desired_salary` `desired_salary` DECIMAL(15,0) NULL DEFAULT NULL;");
$CI->db->query('ALTER TABLE `' . db_prefix() . "rec_candidate`
    CHANGE COLUMN `phonenumber` `phonenumber` TEXT NULL DEFAULT NULL;");

if (!$CI->db->table_exists(db_prefix() . 'cd_skill')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "cd_skill` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `candidate` int(11) NOT NULL,
      `skill_name` text NULL,
      `skill_description` text NULL,
      PRIMARY KEY (`id`,`candidate`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'rec_skill')) {
    $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_skill` (
      `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
      `skill_name` text  NULL,
      PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

  if (!$CI->db->field_exists('skill', 'rec_candidate')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_candidate`
      ADD COLUMN `skill` text
      ;');
  }

  if (!$CI->db->field_exists('interests', 'rec_candidate')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_candidate`
      ADD COLUMN `interests` text
      ;');
  }

    //update recruitment portal
  if (!$CI->db->table_exists(db_prefix() . 'rec_company')) {
      $CI->db->query('CREATE TABLE `' . db_prefix() . "rec_company` (

        `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        `company_name` varchar(200) NOT NULL,
        `company_description` text NULL,
        `company_address` varchar(200) NULL,
        `company_industry` text NULL,

        PRIMARY KEY (`id`)
      ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
  }

  if (!$CI->db->field_exists('display_salary', 'rec_campaign')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_campaign`
      ADD COLUMN `display_salary` int(15) null
      ;');
  }

  if (!$CI->db->table_exists(db_prefix() . 'job_industry')) {
      $CI->db->query('CREATE TABLE `' . db_prefix() . "job_industry` (

        `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        `industry_name` varchar(200) NOT NULL,
        `industry_description` text NULL,

        PRIMARY KEY (`id`)
      ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
  }

  if (!$CI->db->field_exists('industry_id', 'rec_job_position')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_job_position`
      ADD COLUMN `industry_id` int(15) null
      ;');
  }


  if (!$CI->db->field_exists('company_id', 'rec_job_position')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_job_position`
      ADD COLUMN `company_id` int(15) null
      ;');
  }

  if (!$CI->db->field_exists('job_skill', 'rec_job_position')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_job_position`
      ADD COLUMN `job_skill` text
      ;');
  }

  if (!$CI->db->field_exists('rec_channel_form_id', 'rec_campaign')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_campaign`
    ADD COLUMN `rec_channel_form_id` int(15) null
    ;');
  }
  if (!$CI->db->field_exists('position', 'rec_interview')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_interview`
      ADD COLUMN `position` int(15) null
      ;');
  }

    if (!$CI->db->field_exists('linkedin', 'rec_candidate')) {
        $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_candidate`
      ADD COLUMN `linkedin` text null
      ;');
    }

  if (!$CI->db->field_exists('alternate_contact_number', 'rec_candidate')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_candidate`
      ADD COLUMN `alternate_contact_number` varchar(15) null
      ;');
  }

/*if (recruitment_row_options_exist('"recruitment_create_campaign_with_plan "') == 0) {
    $CI->db->query('INSERT INTO `tbloptions` (`name`,`value`, `autoload`) VALUES ("recruitment_create_campaign_with_plan", "1", "1");
  ');
}*/

  if (!$CI->db->field_exists('company_id', 'rec_campaign')) {
      $CI->db->query('ALTER TABLE `'.db_prefix() . 'rec_campaign`
    ADD COLUMN `company_id` int(15) null
    ;');
  }
