<?php

    defined('BASEPATH') or exit('No direct script access allowed');

    /**
     * Recruitment Controller
     */
    class Remarketing extends AdminController
    {
        public function __construct()
        {
            parent::__construct();
            $this->load->model('remarketing_model');
        }

        public function google()
        {
            if (!has_permission('remarketing', '', 'edit') && !is_admin()) {
                access_denied('remarketing');
            }

            if ($this->input->post()) {
                $this->remarketing_model->set($this->input->post());
                set_alert('success', 'Uopdated with success');
                redirect(admin_url('remarketing/google'));
            }

            $data['google'] = $this->remarketing_model->get(array('type' => 'google'));

            $this->load->view('google', $data);
        }

        public function facebook()
        {
            if (!has_permission('remarketing', '', 'edit') && !is_admin()) {
                access_denied('remarketing');
            }

            if ($this->input->post()) {
                $this->remarketing_model->set($this->input->post());
                set_alert('success', 'Uopdated with success');
                redirect(admin_url('remarketing/facebook'));
            }

            $data['facebook'] = $this->remarketing_model->get(array('type' => 'facebook'));

            $this->load->view('facebook', $data);
        }

        public function linkedin()
        {
            if (!has_permission('remarketing', '', 'edit') && !is_admin()) {
                access_denied('remarketing');
            }

            if ($this->input->post()) {
                $this->remarketing_model->set($this->input->post());
                set_alert('success', 'Uopdated with success');
                redirect(admin_url('remarketing/linkedin'));
            }

            $data['linkedin'] = $this->remarketing_model->get(array('type' => 'linkedin'));

            $this->load->view('linkedin', $data);
        }
    }
