<?php

    defined('BASEPATH') or exit('No direct script access allowed');

    /*
    Module Name: Remarketing
    Description: Remarketing Google, Facebook, Linkedin
    Version: 2.3.0
    */

    define('REMARKETING_MODULE_NAME', 'remarketing');


    $CI = &get_instance();

    hooks()->add_action('admin_init', 'remarketing_init_menu_items');
    hooks()->add_action('app_admin_head', 'remarketing_app_admin_head');
    hooks()->add_action('app_customers_head', 'remarketing_app_customers_head');

    /**
     * Register activation module hook
     */
    register_activation_hook(REMARKETING_MODULE_NAME, 'remarketing_activation_hook');

    /**
     * Register language files, must be registered if the module is using languages
     */
    register_language_files(REMARKETING_MODULE_NAME, [REMARKETING_MODULE_NAME]);

    function remarketing_activation_hook()
    {
        $CI = &get_instance();
        //require_once(__DIR__ . '/install.php');
    }

    /**
     * Init menu setup module menu items in setup in admin_init hook
     * @return null
     */
    function remarketing_init_menu_items()
    {
        /**
         * If the logged in user is administrator, add custom menu in Setup
         */
        $CI = &get_instance();

        $CI->app_menu->add_setup_children_item('marketing', [
            'slug'=>'setup_menu_remarketing__google',
            'href'     => admin_url('remarketing/google'),
            'name'     => _l('setup_menu_remarketing__google'),
            'position' => 5,
        ]);
        $CI->app_menu->add_setup_children_item('marketing', [
            'slug'=>'setup_menu_remarketing__facebook',
            'href'     => admin_url('remarketing/facebook'),
            'name'     => _l('setup_menu_remarketing__facebook'),
            'position' => 6,
        ]);
        $CI->app_menu->add_setup_children_item('marketing', [
            'slug'=>'setup_menu_remarketing__linkedin',
            'href'     => admin_url('remarketing/linkedin'),
            'name'     => _l('setup_menu_remarketing__linkedin'),
            'position' => 7,
        ]);

        // $CI->app_menu->add_setup_children_item(
        // 	'remarketing',
        // 	[
        // 		'slug'     => 'google',
        // 		'name'     => _l('Google'),
        // 		'href'     => admin_url('remarketing/google'),
        // 		'position' => 1,
        // 	]
        // );
        //
        // $CI->app_menu->add_setup_children_item(
        // 	'remarketing',
        // 	[
        // 		'slug'     => 'facebook',
        // 		'name'     => _l('Facebook'),
        // 		'href'     => admin_url('remarketing/facebook'),
        // 		'position' => 1,
        // 	]
        // );
        //
        // $CI->app_menu->add_setup_children_item(
        // 	'remarketing',
        // 	[
        // 		'slug'     => 'linkedin',
        // 		'name'     => _l('Linkedin'),
        // 		'href'     => admin_url('remarketing/linkedin'),
        // 		'position' => 1,
        // 	]
        // );
    }

    function remarketing_app_admin_head()
    {
        $CI = &get_instance();

        $CI->load->model('remarketing/remarketing_model');

        $google = $CI->remarketing_model->get(array('type' => 'google'));
        echo $google->admin_client;
        echo $google->admin;

        $facebook = $CI->remarketing_model->get(array('type' => 'facebook'));
        echo $facebook->admin_client;
        echo $facebook->admin;

        $linkedin = $CI->remarketing_model->get(array('type' => 'linkedin'));
        echo $linkedin->admin_client;
        echo $linkedin->admin;
    }

    function remarketing_app_customers_head()
    {
        $CI = &get_instance();

        $CI->load->model('remarketing/remarketing_model');

        $google = $CI->remarketing_model->get(array('type' => 'google'));
        echo $google->admin_client;
        echo $google->client;

        $facebook = $CI->remarketing_model->get(array('type' => 'facebook'));
        echo $facebook->admin_client;
        echo $facebook->client;

        $linkedin = $CI->remarketing_model->get(array('type' => 'linkedin'));
        echo $linkedin->admin_client;
        echo $linkedin->client;
    }
