<?php

defined('BASEPATH') or exit('No direct script access allowed');
/**
 * This class describes a resource workload model.
 */
class Resource_workload_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    /**
     * Gets the data workload.
     *
     * @param object $data_fill The data fill
     *
     * @return array the data workload
     */
    public function get_data_workload($data_fill, $only_data = false)
    {
        $from_date = $data_fill['from_date'];
        $to_date = $data_fill['to_date'];
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($data_fill['from_date']);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($data_fill['to_date']);
        }
        $staffs = $this->get_staff_workload($data_fill);
        $staffsTasksWhere = [];
        if ($from_date != '' && $to_date != '') {
            $staffsTasksWhere = 'IF(duedate IS NOT NULL,((startdate <= "'.$from_date.'" and duedate >= "'.$from_date.'") or (startdate <= "'.$to_date.'" and duedate >= "'.$to_date.'") or (startdate > "'.$from_date.'" and duedate < "'.$to_date.'")), IF(datefinished IS NOT NULL,((startdate <= "'.$from_date.'" and date_format(datefinished, "%Y-%m-%d") >= "'.$from_date.'") or (startdate <= "'.$to_date.'" and date_format(datefinished, "%Y-%m-%d") >= "'.$to_date.'") or (startdate > "'.$from_date.'" and date_format(datefinished, "%Y-%m-%d") < "'.$to_date.'")),(startdate <= "'.$from_date.'" or (startdate > "'.$from_date.'" and startdate <= "'.$to_date.'"))))';
        } elseif ($from_date != '') {
            $staffsTasksWhere = '(startdate >= "'.$from_date.'" or IF(duedate IS NOT NULL, duedate >= "'.$from_date.'", IF(datefinished IS NOT NULL, date_format(datefinished, "%Y-%m-%d") >= "'.$from_date.'", 1=1)))';
        } elseif ($to_date != '') {
            $staffsTasksWhere = '(startdate <= "'.$to_date.'" or IF(duedate IS NOT NULL,duedate <= "'.$to_date.'",IF(datefinished IS NOT NULL, date_format(datefinished, "%Y-%m-%d") <= "'.$to_date.'", 1=1)))';
        }
        $data = [];
        $data_overload = [];
        $data_tooltip = [];

        foreach ($staffs as $key => $value) {
            $row = [];
            $row['staff_id'] = $value['staffid'];
            $row['staff_name'] = $value['full_name'];
            $row['staff_role'] = $value['role_name'];
            $department = $this->departments_model->get_staff_departments($value['staffid']);
            if (isset($department[0])) {
                $row['staff_department'] = $department[0]['name'];
            } else {
                $row['staff_department'] = '';
            }

            $row = $this->create_array_data_workload($from_date, $to_date, $row);
            if ($only_data == false) {
                $data_tooltip_2 = $this->create_array_data_tooltip_workload($value['staffid'], $from_date, $to_date, []);
            }

            $staff_task = $this->tasks_model->get_tasks_by_staff_id($value['staffid'], $staffsTasksWhere);
            foreach ($staff_task as $key_task => $task) {
                if ($task['duedate'] == '') {
                    if ($task['datefinished'] == '') {
                        $task['duedate'] = date('Y-m-d');
                    } else {
                        $task['duedate'] = date('Y-m-d', strtotime($task['datefinished']));
                    }
                }
                $note = [];
                $note['total_time'] = ($this->tasks_model->calc_task_total_time($task['id'], ' AND staff_id=' . $value['staffid']) / 60) / 60;
                $note['estimate_hour'] = $this->get_estimate_hour($task['id']);
                if ($note['estimate_hour'] > 0 || $note['total_time'] > 0) {
                    $number_day = $this->get_number_day($task['startdate'], $task['duedate']);

                    if ($number_day > 0) {
                        $f_date = $task['startdate'];
                        $t_date = $task['duedate'];

                        $total_time = $note['total_time'];
                        $estimate_hour = $note['estimate_hour'];

                        $_total_time = 0;
                        $_estimate_hour = 0;

                        while (strtotime($f_date) <= strtotime($t_date)) {
                            if ($estimate_hour > 0 || $total_time > 0) {
                                $standard_workload = $this->get_standard_workload_by_staff($value['staffid'], $f_date);

                                if ($this->check_date_working($f_date)) {
                                    if ($this->get_total_standard_workload($value['staffid'], $task['startdate'], $task['duedate']) < $note['total_time']) {
                                        $_total_time = round($note['total_time'] / ($number_day), 2);
                                    } else {
                                        if ($total_time >= $standard_workload) {
                                            $_total_time = $standard_workload;
                                            $total_time = $total_time - $standard_workload;
                                        } else {
                                            $_total_time = $total_time;
                                            $total_time = 0;
                                        }
                                    }

                                    if ($this->get_total_standard_workload($value['staffid'], $task['startdate'], $task['duedate']) < $note['estimate_hour']) {
                                        $_estimate_hour = round($note['estimate_hour'] / ($number_day), 2);
                                    } else {
                                        if ($estimate_hour >= $standard_workload) {
                                            $_estimate_hour = $standard_workload;

                                            $estimate_hour = $estimate_hour - $standard_workload;
                                        } else {
                                            $_estimate_hour = $estimate_hour;
                                            $estimate_hour = 0;
                                        }
                                    }
                                    if (isset($row[date('d_m_Y', strtotime($f_date)) . '_e'])) {
                                        $row[date('d_m_Y', strtotime($f_date)) . '_e'] += round($_estimate_hour, 2);
                                        if ($_estimate_hour > 0 && $only_data == false) {
                                            $data_tooltip_2[$value['staffid'] . '_' . date('d_m_Y', strtotime($f_date)) . '_e'] .= $task['name'] . ': ' . round($_estimate_hour, 2) . ' ' . _l('hours') . "\n";
                                        }
                                    }
                                    if (isset($row[date('d_m_Y', strtotime($f_date)) . '_s'])) {
                                        $row[date('d_m_Y', strtotime($f_date)) . '_s'] += round($_total_time, 2);
                                        if ($_total_time > 0 && $only_data == false) {
                                            $data_tooltip_2[$value['staffid'] . '_' . date('d_m_Y', strtotime($f_date)) . '_s'] .= $task['name'] . ': ' . round($_total_time, 2) . ' ' . _l('hours') . "\n";
                                        }
                                    }
                                }
                            } else {
                                $f_date = $t_date;
                            }

                            $f_date = date('Y-m-d', strtotime('+1 day', strtotime($f_date)));
                        }
                    } else {
                        if (isset($row[date('d_m_Y', strtotime($task['startdate'])) . '_e'])) {
                            $row[date('d_m_Y', strtotime($task['startdate'])) . '_e'] += round($note['estimate_hour'], 2);
                            if ($note['estimate_hour'] > 0 && $only_data == false) {
                                $data_tooltip_2[$value['staffid'] . '_' . date('d_m_Y', strtotime($task['startdate'])) . '_e'] .= $task['name'] . ': ' . round($note['estimate_hour'], 2) . ' ' . _l('hours') . "\n";
                            }
                        }
                        if (isset($row[date('d_m_Y', strtotime($task['startdate'])) . '_s'])) {
                            $row[date('d_m_Y', strtotime($task['startdate'])) . '_s'] += round($note['total_time'], 2);
                            if ($note['estimate_hour'] > 0 && $only_data == false) {
                                $data_tooltip_2[$value['staffid'] . '_' . date('d_m_Y', strtotime($task['startdate'])) . '_s'] .= $task['name'] . ': ' . round($note['total_time'], 2) . ' ' . _l('hours') . "\n";
                            }
                        }
                    }
                }
            }

            $int = 4;
            if ($only_data == false) {
                foreach ($data_tooltip_2 as $key_tooltip => $tooltip) {
                    $n = [];
                    $n['row'] = $key;
                    $n['col'] = $int;
                    $n['comment'] = ['value' => $tooltip];
                    array_push($data_tooltip, $n);
                    $int++;
                }
            }
            $overload = [];
            foreach ($row as $key => $value) {
                if ($only_data == false) {
                    if (!(strpos($key, '_e') === false) || !(strpos($key, '_s') === false)) {
                        $k = explode('_', $key);
                        $standard_workload = $this->get_standard_workload_by_staff($row['staff_id'], $k[2].'-'.$k[1].'-'.$k[0]);

                        if ($standard_workload < $value) {
                            $overload[$key] = 1;
                        }
                    }
                }
                if (!is_array($value) && $value > 0) {
                    $row[$key] = $value.'';
                }
            }
            $data[] = $row;
            $data_overload[] = $overload;
        }

        $data_return = [];
        $data_return['data'] = $data;
        $data_return['data_tooltip'] = $data_tooltip;
        $data_return['data_overload'] = $data_overload;
        return $data_return;
    }

    /**
     * Gets the data timeline.
     *
     * @param object $data_fill The data fill
     *
     * @return array the data timeline
     */
    public function get_data_timeline($data_fill)
    {
        $from_date = $data_fill['from_date'];
        $to_date = $data_fill['to_date'];
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($data_fill['from_date']);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($data_fill['to_date']);
        }
        $staffs = $this->get_staff_workload($data_fill);
        $staffsTasksWhere = [];
        if ($from_date != '' && $to_date != '') {
            $staffsTasksWhere = 'IF(duedate IS NOT NULL,((startdate <= "'.$from_date.'" and duedate >= "'.$from_date.'") or (startdate <= "'.$to_date.'" and duedate >= "'.$to_date.'") or (startdate > "'.$from_date.'" and duedate < "'.$to_date.'")), IF(datefinished IS NOT NULL,((startdate <= "'.$from_date.'" and date_format(datefinished, "%Y-%m-%d") >= "'.$from_date.'") or (startdate <= "'.$to_date.'" and date_format(datefinished, "%Y-%m-%d") >= "'.$to_date.'") or (startdate > "'.$from_date.'" and date_format(datefinished, "%Y-%m-%d") < "'.$to_date.'")),(startdate <= "'.$from_date.'" or (startdate > "'.$from_date.'" and startdate <= "'.$to_date.'"))))';
        } elseif ($from_date != '') {
            $staffsTasksWhere = '(startdate >= "'.$from_date.'" or IF(duedate IS NOT NULL, duedate >= "'.$from_date.'", IF(datefinished IS NOT NULL, date_format(datefinished, "%Y-%m-%d") >= "'.$from_date.'", 1=1)))';
        } elseif ($to_date != '') {
            $staffsTasksWhere = '(startdate <= "'.$to_date.'" or IF(duedate IS NOT NULL,duedate <= "'.$to_date.'",IF(datefinished IS NOT NULL, date_format(datefinished, "%Y-%m-%d") <= "'.$to_date.'", 1=1)))';
        }
        $data = [];
        $data_tooltip = [];
        $data_color = [];
        $data_check = [];
        foreach ($staffs as $key => $value) {
            $row = [];
            $row['id'] = 'staff_' . $value['staffid'];
            $row['start'] = $from_date;
            $row['end'] = $to_date;
            $row['name'] = $value['full_name'];
            $data[] = $row;

            $staff_task = $this->tasks_model->get_tasks_by_staff_id($value['staffid'], $staffsTasksWhere);
            foreach ($staff_task as $key_task => $task) {
                $note = [];
                $note['start'] = $task['startdate'];
                $note['progress'] = 100;
                $status = get_task_status_by_id($task['status']);
                $note['name'] = $task['name'] . ' - ' . $status['name'];
                $note['id'] = $task['id'];
                $note['dependencies'] = 'staff_' . $value['staffid'];
                if ($task['duedate'] != null) {
                    $note['end'] = $task['duedate'];
                } else {
                    if ($task['datefinished'] == '') {
                        $note['end'] = $to_date;
                    } else {
                        $note['end'] = date('Y-m-d', strtotime($task['datefinished']));
                    }
                }
                $note['total_time'] = round(($this->tasks_model->calc_task_total_time($task['id'], ' AND staff_id=' . $value['staffid'])/ 60) / 60, 2);
                $note['estimate_hour'] = round($this->get_estimate_hour($task['id']), 2);

                switch ($task['rel_type']) {
                case 'project':
                    $note['custom_class'] = 'br_project';
                    break;
                case 'ticket':
                    $note['custom_class'] = 'br_ticket';
                    break;
                case 'lead':
                    $note['custom_class'] = 'br_lead';
                    break;
                case 'customer':
                    $note['custom_class'] = 'br_customer';
                    break;
                case 'contract':
                    $note['custom_class'] = 'br_contract';
                    break;
                case 'invoice':
                    $note['custom_class'] = 'br_invoice';
                    break;
                case 'estimate':
                    $note['custom_class'] = 'br_estimate';
                    break;
                case 'proposal':
                    $note['custom_class'] = 'br_proposal';
                    break;
                }
                $data[] = $note;
            }
            $int = 4;
        }
        if ($data == []) {
            $data[][] = [];
        }
        return $data;
    }

    /**
     * Creates an array data workload.
     *
     * @param String $from_date The from date format dd/mm/YYYY
     * @param String $to_date   To date format dd/mm/YYYY
     * @param array  $array     The array
     *
     * @return array
     */
    public function create_array_data_workload($from_date, $to_date, $array)
    {
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($from_date);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($to_date);
        }

        while (strtotime($from_date) <= strtotime($to_date)) {
            $array[date('d_m_Y', strtotime($from_date)) . '_e'] = 0;
            $array[date('d_m_Y', strtotime($from_date)) . '_s'] = 0;
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $array;
    }

    /**
     * Creates an array data timeline.
     *
     * @param String $from_date The from date format dd/mm/YYYY
     * @param String $to_date   To date format dd/mm/YYYY
     * @param array  $array     The array
     *
     * @return array
     */
    public function create_array_data_timeline($from_date, $to_date, $array)
    {
        $from_date = to_sql_date($from_date);
        $to_date = to_sql_date($to_date);
        while (strtotime($from_date) <= strtotime($to_date)) {
            $array[date('d_m', strtotime($from_date))] = [];
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $array;
    }

    /**
     * Creates an array data tooltip workload.
     *
     * @param string $staffid   The staffid
     * @param string $from_date The from date format dd/mm/YYYY
     * @param string $to_date   To date format dd/mm/YYYY
     * @param array  $array     The array
     *
     * @return array
     */
    public function create_array_data_tooltip_workload($staffid, $from_date, $to_date, $array)
    {
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($from_date);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($to_date);
        }

        while (strtotime($from_date) <= strtotime($to_date)) {
            $array[$staffid . '_' . date('d_m_Y', strtotime($from_date)) . '_e'] = '';
            $array[$staffid . '_' . date('d_m_Y', strtotime($from_date)) . '_s'] = '';
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $array;
    }

    /**
     * Creates an array data tooltip timeline.
     *
     * @param string $staffid   The staffid
     * @param string $from_date The from date format dd/mm/YYYY
     * @param string $to_date   To date format dd/mm/YYYY
     * @param array  $array     The array
     *
     * @return array
     */
    public function create_array_data_tooltip_timeline($staffid, $from_date, $to_date, $array)
    {
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($from_date);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($to_date);
        }

        while (strtotime($from_date) <= strtotime($to_date)) {
            $array[$staffid . '_' . date('d_m', strtotime($from_date))] = '';
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $array;
    }

    /**
     * Gets the nestedheaders workload.
     *
     * @param string $from_date The from date format dd/mm/YYYY
     * @param string $to_date   To date format dd/mm/YYYY
     *
     * @return array the nestedheaders workload
     */
    public function get_nestedheaders_workload($from_date, $to_date)
    {
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($from_date);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($to_date);
        }

        $nestedheaders = [];
        $nestedheaders[0] = [['label' => _l('staff'), 'colspan' => 4]];
        $nestedheaders[1] = [_l('name'), '', _l('department'), _l('role')];
        while (strtotime($from_date) <= strtotime($to_date)) {
            array_push($nestedheaders[0], ['label' => date('l d/m', strtotime($from_date)), 'colspan' => 2]);
            array_push($nestedheaders[1], 'E');
            array_push($nestedheaders[1], 'S');
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $nestedheaders;
    }

    /**
     * Gets the nestedheaders timeline.
     *
     * @param string $from_date The from date format dd/mm/YYYY
     * @param string $to_date   To date format dd/mm/YYYY
     *
     * @return array the nestedheaders timeline
     */
    public function get_nestedheaders_timeline($from_date, $to_date)
    {
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($from_date);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($to_date);
        }

        $nestedheaders = [];
        $nestedheaders[0] = [['label' => _l('staff'), 'colspan' => 4]];
        $nestedheaders[1] = [_l('name'), '', _l('department'), _l('role')];
        while (strtotime($from_date) <= strtotime($to_date)) {
            array_push($nestedheaders[1], date('l d/m', strtotime($from_date)));
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $nestedheaders;
    }

    /**
     * Gets the columns workload.
     *
     * @param string $from_date The from date format dd/mm/YYYY
     * @param string $to_date   To date format dd/mm/YYYY
     *
     * @return array the columns workload
     */
    public function get_columns_workload($from_date, $to_date)
    {
        if (!$this->check_format_date($from_date)) {
            $from_date = to_sql_date($from_date);
        }
        if (!$this->check_format_date($to_date)) {
            $to_date = to_sql_date($to_date);
        }
        $columns = [['data' => 'staff_name', 'type' => 'text', 'readOnly' => true],
            ['data' => 'staff_id', 'type' => 'text', 'readOnly' => true],
            ['data' => 'staff_department', 'type' => 'text', 'readOnly' => true],
            ['data' => 'staff_role', 'type' => 'text', 'readOnly' => true]];
        while (strtotime($from_date) <= strtotime($to_date)) {
            array_push($columns, ['data' => date('d_m_Y', strtotime($from_date)) . '_e', 'type' => 'numeric', 'readOnly' => true, 'numericFormat' => [
                'pattern' => '0.00',
            ]]);
            array_push($columns, ['data' => date('d_m_Y', strtotime($from_date)) . '_s', 'type' => 'numeric', 'readOnly' => true, 'numericFormat' => [
                'pattern' => '0.00',
            ]]);
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $columns;
    }

    /**
     * Gets the columns timeline.
     *
     * @param string $from_date The from date format dd/mm/YYYY
     * @param string $to_date   To date format dd/mm/YYYY
     *
     * @return array the columns timeline
     */
    public function get_columns_timeline($from_date, $to_date)
    {
        $from_date = to_sql_date($from_date);
        $to_date = to_sql_date($to_date);
        $columns = [['data' => 'staff_name', 'type' => 'text', 'readOnly' => true],
            ['data' => 'staff_id', 'type' => 'text', 'readOnly' => true],
            ['data' => 'staff_department', 'type' => 'text', 'readOnly' => true],
            ['data' => 'staff_role', 'type' => 'text', 'readOnly' => true]];
        while (strtotime($from_date) <= strtotime($to_date)) {
            array_push($columns, ['data' => date('d_m', strtotime($from_date)), 'type' => 'numeric', 'readOnly' => true, 'numericFormat' => [
                'pattern' => '0.0',
            ]]);
            $from_date = date('Y-m-d', strtotime('+1 day', strtotime($from_date)));
        }
        return $columns;
    }

    /**
     * Gets the staff workload.
     *
     * @param object $data The data
     *
     * @return array the staff workload
     */
    public function get_staff_workload($data)
    {
        if (isset($data['project']) && !is_array($data['project']) && $data['project'] != '') {
            $data['project'] = explode(',', $data['project']);
        }

        if (isset($data['department']) && !is_array($data['department']) && $data['department'] != '') {
            $data['department'] = explode(',', $data['department']);
        }

        if (isset($data['role']) && !is_array($data['role']) && $data['role'] != '') {
            $data['role'] = explode(',', $data['role']);
        }

        if (isset($data['staff']) && !is_array($data['staff']) && $data['staff'] != '') {
            $data['staff'] = explode(',', $data['staff']);
        }
        $where_project = '';
        if (!empty($data['project'])) {
            foreach ($data['project'] as $key => $value) {
                if ($where_project == '') {
                    $where_project .= '(project_members.project_id = ' . $value;
                } else {
                    $where_project .= ' or project_members.project_id = ' . $value;
                }
            }
            $where_project .= ')';
        }
        $where_department = '';
        if (!empty($data['department'])) {
            foreach ($data['department'] as $key => $value) {
                if ($where_department == '') {
                    $where_department .= '(staff_departments.departmentid = ' . $value;
                } else {
                    $where_department .= ' or staff_departments.departmentid = ' . $value;
                }
            }
            $where_department .= ')';
        }
        $where_role = '';
        if (!empty($data['role'])) {
            foreach ($data['role'] as $key => $value) {
                if ($where_role == '') {
                    $where_role .= '(staff.role = ' . $value;
                } else {
                    $where_role .= ' or staff.role = ' . $value;
                }
            }
            $where_role .= ')';
        }
        $where_staff = '';
        if (!empty($data['staff'])) {
            foreach ($data['staff'] as $key => $value) {
                if ($where_staff == '') {
                    $where_staff .= '(staff.staffid = ' . $value;
                } else {
                    $where_staff .= ' or staff.staffid = ' . $value;
                }
            }
            $where_staff .= ')';
        }

        $this->db->select('*, CONCAT(firstname, \' \', lastname) as full_name,' . db_prefix() . 'staff.staffid as staffid, ' . db_prefix() . 'roles.name as role_name');
        $this->db->join(db_prefix() . 'roles', db_prefix() . 'staff.role=' . db_prefix() . 'roles.roleid', 'left');
        $this->db->join(db_prefix() . 'project_members', db_prefix() . 'staff.staffid=' . db_prefix() . 'project_members.staff_id', 'left');
        $this->db->join(db_prefix() . 'staff_departments', db_prefix() . 'staff.staffid=' . db_prefix() . 'staff_departments.staffid', 'left');

        if ($where_role !== '') {
            $this->db->where($where_role);
        }
        if ($where_department !== '') {
            $this->db->where($where_department);
        }
        if ($where_project !== '') {
            $this->db->where($where_project);
        }
        if ($where_staff !== '') {
            $this->db->where($where_staff);
        }
        $this->db->where('active', 1);
        $list_staffs = $this->db->get(db_prefix() . 'staff')->result_array();

        $list = [];
        $list_return = [];
        foreach ($list_staffs as $key => $value) {
            if (!in_array($value['staffid'], $list)) {
                $list_return[] = $value;
                $list[] = $value['staffid'];
            }
        }
        return $list_return;
    }

    /**
     * Gets the name relative type.
     *
     * @param int    $id       The identifier
     * @param string $rel_type The relative type
     *
     * @return string the name relative type
     */
    public function get_name_rel_type($id, $rel_type)
    {
        switch ($rel_type) {
        case 'project':
            $this->load->model('Projects_model');
            return $this->Projects_model->get($id)->name;
            break;
        case 'ticket':
            $this->load->model('Tickets_model');
            return $this->Tickets_model->get($id)->subject;
            break;
        case 'lead':
            $this->load->model('Leads_model');
            return $this->Leads_model->get($id)->name;
            break;
        case 'customer':
            $this->load->model('Clients_model');
            return $this->Clients_model->get($id)->company;
            break;
        case 'contract':
            $this->load->model('Contracts_model');
            return $this->Contracts_model->get($id)->subject;
            break;
        case 'invoice':
            return format_invoice_number($id);
            break;
        case 'estimate':
            $this->load->model('Estimates_model');
            return $this->Estimates_model->get($id)->category_name;
            break;
        case 'proposal':
            return format_proposal_number($id);
            break;
        case 'account_planning':
            $this->db->where('id', $id);
            return $this->db->get(db_prefix() . 'account_planning')->row()->subject;
            break;
        default:
            return '';
            break;
        }
    }

    /**
     * Gets the color relative type.
     *
     * @param string $rel_type The relative type
     *
     * @return string the color relative type
     */
    public function get_color_rel_type($rel_type)
    {
        switch ($rel_type) {
        case 'project':
            return '84C529';
            break;
        case 'ticket':
            return '8085E9';
            break;
        case 'lead':
            return 'cc66ff';
            break;
        case 'customer':
            return '03a9f4';
            break;
        case 'contract':
            return 'ff6f00';
            break;
        case 'invoice':
            return 'ff9900';
            break;
        case 'estimate':
            return 'ff5050';
            break;
        case 'proposal':
            return '3333cc';
            break;
        case 'account_planning':
            return '993333';
            break;
        case 'expense':
            return '2af509';
            break;
        default:
            return '';
            break;
        }
    }

    /**
     * get data estimate stats
     *
     * @return object
     */
    public function estimate_stats($data)
    {
        $total_normal = 0;
        $total_overload = 0;
        foreach ($data['data'] as $workload) {
            foreach ($workload as $key => $value) {
                if (!(strpos($key, '_e') === false)) {
                    $key = explode('_', $key);
                    $standard_workload = $this->get_standard_workload_by_staff($workload['staff_id'], $key[2].'-'.$key[1].'-'.$key[0]);
                    $overload = $value - $standard_workload;
                    if ($overload > 0) {
                        $total_overload += $overload;
                        $total_normal += $standard_workload;
                    } else {
                        $total_normal += $value;
                    }
                }
            }
        }

        $chart = [];

        $status_1 = ['name' => _l('overload'), 'color' => '#fc2d42', 'y' => 0];
        $status_2 = ['name' => _l('normal'), 'color' => '#84c529', 'y' => 0];
        $status_1['y'] = round($total_overload, 1);
        $status_2['y'] = round($total_normal, 1);
        if ($status_1['y'] > 0) {
            array_push($chart, $status_1);
        }
        if ($status_2['y'] > 0) {
            array_push($chart, $status_2);
        }
        return $chart;
    }

    /**
     * Gets the estimate hour.
     *
     * @param int $task_id The task identifier
     *
     * @return integer the estimate hour
     */
    public function get_estimate_hour($task_id)
    {
        $this->db->where('fieldto', 'tasks');
        $this->db->where('slug', 'tasks_estimate_hour');
        $customfield_estimate_hour = $this->db->get(db_prefix() . 'customfields')->row();
        $value = 0;
        if (isset($customfield_estimate_hour->id)) {
            $this->db->where('fieldid', $customfield_estimate_hour->id);
            $this->db->where('relid', $task_id);
            $customfieldsvalues = $this->db->get(db_prefix() . 'customfieldsvalues')->row();
            if (isset($customfieldsvalues->id)) {
                $value = $customfieldsvalues->value;
            }
        }
        return $value;
    }

    /**
     * get data spent stats
     *
     * @return object
     */
    public function spent_stats($data)
    {
        $total_normal = 0;
        $total_overload = 0;
        foreach ($data['data'] as $workload) {
            foreach ($workload as $key => $value) {
                if (!(strpos($key, '_s') === false)) {
                    $key = explode('_', $key);
                    $standard_workload = $this->get_standard_workload_by_staff($workload['staff_id'], $key[2].'-'.$key[1].'-'.$key[0]);
                    $overload = $value - $standard_workload;
                    if ($overload > 0) {
                        $total_overload += $overload;
                        $total_normal += $standard_workload;
                    } else {
                        $total_normal += $value;
                    }
                }
            }
        }

        $chart = [];

        $status_1 = ['name' => _l('overload'), 'color' => '#ff9900', 'y' => 0];
        $status_2 = ['name' => _l('normal'), 'color' => '#66ccff', 'y' => 0];
        $status_1['y'] = round($total_overload, 1);
        $status_2['y'] = round($total_normal, 1);
        if ($status_1['y'] > 0) {
            array_push($chart, $status_1);
        }
        if ($status_2['y'] > 0) {
            array_push($chart, $status_2);
        }
        return $chart;
    }

    /**
     * get data department stats
     *
     * @return object
     */
    public function department_stats($data)
    {
        $not_in_department = _l('not_in_department');
        $total_normal = 0;
        $total_overload = 0;
        $department = array();
        foreach ($data['data'] as $workload) {
            $dept_text = $not_in_department;
            foreach ($workload as $key => $value) {
                if (!(strpos($key, 'staff_department') === false)) {
                    if (trim($value) != '') {
                        $dept_text = $value;
                    }
                    if (!isset($department[$dept_text])) {
                        $department[$dept_text] = array();
                        $department[$dept_text]['estimate_overload'] = 0;
                        $department[$dept_text]['estimate_normal'] = 0;
                        $department[$dept_text]['spent_overload'] = 0;
                        $department[$dept_text]['spent_normal'] = 0;
                    }
                }
                if (!(strpos($key, '_e') === false)) {
                    $k = explode('_', $key);
                    $standard_workload = $this->get_standard_workload_by_staff($workload['staff_id'], $k[2].'-'.$k[1].'-'.$k[0]);
                    $overload = $value - $standard_workload;
                    if ($overload > 0) {
                        $department[$dept_text]['estimate_overload'] += $overload;
                        $department[$dept_text]['estimate_normal'] += $standard_workload;
                    } else {
                        $department[$dept_text]['estimate_normal'] += $value;
                    }
                }
                if (!(strpos($key, '_s') === false)) {
                    $k = explode('_', $key);
                    $standard_workload = $this->get_standard_workload_by_staff($workload['staff_id'], $k[2].'-'.$k[1].'-'.$k[0]);
                    $overload = $value - $standard_workload;
                    if ($overload > 0) {
                        $department[$dept_text]['spent_overload'] += $overload;
                        $department[$dept_text]['spent_normal'] += $standard_workload;
                    } else {
                        $department[$dept_text]['spent_normal'] += $value;
                    }
                }
            }
        }

        $chart = [];

        $status_1 = ['name' => _l('estimate_overload'), 'data' => [], 'stack' => 'male', 'color' => '#fc2d42'];
        $status_2 = ['name' => _l('estimate_normal'), 'data' => [], 'stack' => 'male', 'color' => '#84c529'];
        $status_3 = ['name' => _l('spent_normal'), 'data' => [], 'stack' => 'female', 'color' => '#66ccff'];
        $status_4 = ['name' => _l('spent_overload'), 'data' => [], 'stack' => 'female', 'color' => '#ff9900'];

        $columns = array();
        foreach ($department as $key => $dept) {
            array_push($status_1['data'], round($dept['estimate_overload'], 1));
            array_push($status_2['data'], round($dept['estimate_normal'], 1));
            array_push($status_4['data'], round($dept['spent_overload'], 1));
            array_push($status_3['data'], round($dept['spent_normal'], 1));

            array_push($columns, $key);
        }
        array_push($chart, $status_1);
        array_push($chart, $status_2);
        array_push($chart, $status_4);
        array_push($chart, $status_3);
        $result = array();
        $result['department_stats'] = $chart;
        $result['column_department'] = $columns;
        return $result;
    }

    /**
     * Gets the column department statistics.
     *
     * @return object
     */
    public function get_column_department_stats()
    {
        $departments = $this->departments_model->get();
        $department = [];
        foreach ($departments as $key => $value) {
            array_push($department, $value['name']);
        }
        return $department;
    }

    /**
     * check format date Y-m-d
     *
     * @param String $date The date
     *
     * @return boolean
     */
    public function check_format_date($date)
    {
        if (preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $date)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * Gets the number day.
     *
     * @param string $from_date The from date
     * @param string $to_date   To date
     *
     * @return integer the number day
     */
    public function get_number_day($from_date, $to_date)
    {
        $count = 0;
        if ($to_date == '') {
            $to_date = date('Y-m-d');
        }
        for ($i=0; $i < 5; $i++) {
            if (strtotime($from_date) <= strtotime($to_date)) {
                if ($this->check_date_working($from_date)) {
                    $count++;
                }

                $from_date = date('Y-m-d', strtotime($from_date. ' + 1 days'));
                $i = 0;
            } else {
                $i = 10;
            }
        }
        return $count;
    }

    /**
     * check date working
     *
     * @param String $date The date
     *
     * @return boolean
     */
    public function check_date_working($date)
    {
        $working_days = [];
        $working_days[1] = get_option('staff_workload_monday');
        $working_days[2] = get_option('staff_workload_tuesday');
        $working_days[3] = get_option('staff_workload_wednesday');
        $working_days[4] = get_option('staff_workload_thursday');
        $working_days[5] = get_option('staff_workload_friday');
        $working_days[6] = get_option('staff_workload_saturday');
        $working_days[7] = get_option('staff_workload_sunday');

        $this->db->where('date', $date);
        $workload_dayoff = $this->db->get(db_prefix() . 'workload_dayoff')->row();

        if ($working_days[date('N', strtotime($date))] == '1' && !$workload_dayoff) {
            return true;
        }

        return false;
    }

    /**
     * task date change
     *
     * @param object $data The data
     *
     * @return boolean
     */
    public function task_date_change($data)
    {
        $this->load->model('tasks_model');

        $this->db->where('fieldto', 'tasks');
        $this->db->where('name', 'Estimate hour');
        $estimate_fields = $this->db->get(db_prefix().'customfields')->row();
        $affectedRows = 0;
        $estimate = 0;
        if ($estimate_fields) {
            $task_assignees = $this->tasks_model->get_task_assignees($data['task_id']);
            $staffid = '';

            if (isset($task_assignees[0]['assigneeid'])) {
                $staffid = $task_assignees[0]['assigneeid'];
            }

            if ($staffid == '') {
                $number_day = $this->get_number_day($data['start_date'], $data['end_date']);
                $standard_workload = get_option('standard_workload');
                if ($standard_workload == '') {
                    $standard_workload = 0;
                }
                $estimate = $number_day * $standard_workload;
            } else {
                $f_date = $data['start_date'];
                $t_date = $data['end_date'];

                while (strtotime($f_date) <= strtotime($t_date)) {
                    if ($this->check_date_working($f_date)) {
                        $standard_workload = $this->get_standard_workload_by_staff($staffid, $f_date);

                        $estimate += $standard_workload;
                    }

                    $f_date = date('Y-m-d', strtotime('+1 day', strtotime($f_date)));
                }
            }

            $this->db->where('relid', $data['task_id']);
            $this->db->where('fieldid', $estimate_fields->id);
            $this->db->where('fieldto', 'tasks');
            $_fields = $this->db->get(db_prefix().'customfieldsvalues')->row();

            if ($_fields) {
                $this->db->where('relid', $data['task_id']);
                $this->db->where('fieldid', $estimate_fields->id);
                $this->db->where('fieldto', 'tasks');
                $this->db->update(db_prefix().'customfieldsvalues', ['value' => $estimate]);

                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }
            } else {
                $this->db->where('relid', $data['task_id']);
                $this->db->where('fieldid', $estimate_fields->id);
                $this->db->where('fieldto', 'tasks');
                $this->db->insert(db_prefix().'customfieldsvalues', ['relid' => $data['task_id'],
                    'fieldto' => 'tasks',
                    'fieldid' => $estimate_fields->id,
                    'value' => $estimate]);
                $insert_id = $this->db->insert_id();
                if ($insert_id) {
                    $affectedRows++;
                }
            }
        }

        $this->db->where('id', $data['task_id']);
        $this->db->update(db_prefix().'tasks', ['startdate' => $data['start_date'], 'duedate' => $data['end_date']]);

        if ($this->db->affected_rows() > 0) {
            $affectedRows++;
        }

        if ($affectedRows > 0) {
            return true;
        }
        return false;
    }

    /**
     * Does a workload kanban query.
     *
     * @param int     $staff_id The staff identifier
     * @param integer $page     The page
     * @param array   $where    The where
     * @param boolean $count    The count
     *
     * @return object
     */
    public function do_workload_kanban_query($staff_id, $page = 1, $where = [], $count = false)
    {
        if ($count == false) {
            if ($page > 1) {
                $page--;
                $position = ($page * 10);
                $this->db->limit(10, $position);
            } else {
                $this->db->limit(10);
            }
        }

        return $this->get_tasks($staff_id, $where, true, $count);
    }

    /**
     * Gets the tasks.
     *
     * @param string  $staff_id           The staff identifier
     * @param array   $where              The where
     * @param boolean $apply_restrictions The apply restrictions
     * @param boolean $count              The count
     *
     * @return array the tasks
     */
    public function get_tasks($staff_id = '', $where = [], $apply_restrictions = false, $count = false)
    {
        $select = implode(', ', prefixed_table_fields_array(db_prefix() . 'tasks')) . ',
        (SELECT SUM(CASE
            WHEN end_time is NULL THEN ' . time() . '-start_time
            ELSE end_time-start_time
            END) FROM ' . db_prefix() . 'taskstimers WHERE task_id=' . db_prefix() . 'tasks.id) as total_logged_time,
           ' . get_sql_select_task_assignees_ids() . ' as assignees_ids
        ';

        $select .= ',(SELECT staffid FROM ' . db_prefix() . 'task_assigned WHERE taskid=' . db_prefix() . 'tasks.id AND staffid=' . get_staff_user_id() . ') as current_user_is_assigned';

        $this->db->select($select);

        if ($staff_id != '') {
            $this->db->where('(' . db_prefix() . 'tasks.id IN (SELECT taskid FROM ' . db_prefix() . 'task_assigned WHERE staffid = ' . $staff_id . '))');
        }


        $this->db->where($where);

        $this->db->order_by('FIELD(status, 5), duedate IS NULL ASC, duedate', '', false);

        if ($count == false) {
            $tasks = $this->db->get(db_prefix() . 'tasks')->result_array();
        } else {
            $tasks = $this->db->count_all_results(db_prefix() . 'tasks');
        }

        return $tasks;
    }

    /**
     * Gets the dayoff.
     *
     * @return array the dayoff
     */
    public function get_dayoff()
    {
        return $this->db->get(db_prefix().'workload_dayoff')->result_array();
    }
    /**
     * Adds a dayoff.
     *
     * @param object $data The data
     *
     * @return boolean
     */
    public function add_dayoff($data)
    {
        $data['addedfrom'] = get_staff_user_id();
        $data['datecreated'] = date('Y-m-d H:i:s');

        if (!$this->check_format_date($data['date'])) {
            $data['date'] = to_sql_date($data['date']);
        }
        $this->db->insert(db_prefix().'workload_dayoff', $data);

        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            return true;
        }
        return false;
    }

    /**
     * update dayoff
     *
     * @param object $data The data
     * @param int    $id   The identifier
     *
     * @return boolean
     */
    public function update_dayoff($data, $id)
    {
        if (!$this->check_format_date($data['date'])) {
            $data['date'] = to_sql_date($data['date']);
        }
        $this->db->where('id', $id);
        $this->db->update(db_prefix().'workload_dayoff', $data);

        if ($this->db->affected_rows() > 0) {
            return true;
        }
        return false;
    }

    /**
     * Gets the department name.
     *
     * @param int $departmentid The departmentid
     *
     * @return string the department name
     */
    public function get_department_name($departmentid)
    {
        $department = $this->db->query('select '.db_prefix().'departments.name from '.db_prefix().'departments where departmentid = '.$departmentid)->row();
        if ($department) {
            return $department->name;
        }
        return '';
    }

    /**
     * delete day off
     *
     * @param int $id The identifier
     *
     * @return boolean
     */
    public function delete_dayoff($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'workload_dayoff');
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }

    /**
     * Gets the list standard workload.
     *
     * @return array the list standard workload
     */
    public function get_list_standard_workload()
    {
        $this->load->model('staff_model');
        $staff = $this->staff_model->get('', ['active' => 1]);

        $standard_workload = $this->db->get(db_prefix() . 'standard_workload')->result_array();

        $working_days = [];
        $working_days[1] = get_option('staff_workload_monday');
        $working_days[2] = get_option('staff_workload_tuesday');
        $working_days[3] = get_option('staff_workload_wednesday');
        $working_days[4] = get_option('staff_workload_thursday');
        $working_days[5] = get_option('staff_workload_friday');
        $working_days[6] = get_option('staff_workload_saturday');
        $working_days[7] = get_option('staff_workload_sunday');

        $list_staff = [];
        foreach ($standard_workload as $key => $value) {
            $list_staff[] = $value['staffid'];
        }
        $st = get_option('standard_workload');
        foreach ($staff as $key => $value) {
            if (!in_array($value['staffid'], $list_staff)) {
                $node = [];
                $node['staffid'] = $value['staffid'];
                if ($working_days[1] == 1) {
                    $node['monday'] = $st;
                }
                if ($working_days[2] == 1) {
                    $node['tuesday'] = $st;
                }
                if ($working_days[3] == 1) {
                    $node['wednesday'] = $st;
                }
                if ($working_days[4] == 1) {
                    $node['thursday'] = $st;
                }
                if ($working_days[5] == 1) {
                    $node['friday'] = $st;
                }
                if ($working_days[6] == 1) {
                    $node['saturday'] = $st;
                }
                if ($working_days[7] == 1) {
                    $node['sunday'] = $st;
                }

                $standard_workload[] = $node;
            }
        }

        return $standard_workload;
    }

    /**
     * Gets the staff standard workload.
     *
     * @return array the staff standard workload
     */
    public function get_staff_standard_workload()
    {
        $this->db->where('(select count(*) from '. db_prefix() . 'standard_workload where staffid = '.db_prefix() . 'staff.staffid) = 0');
        $data = $this->db->get(db_prefix() . 'staff')->result_array();
        $list_staff = [];
        foreach ($data as $key => $value) {
            $list_staff[] = $value['staffid'];
        }
        $staffs = $this->staff_model->get('', ['active' => 1]);
        foreach ($staffs as $key => $value) {
            if (is_array($value['staffid'], $list_staff)) {
            }
        }
    }

    /**
     * Adds a standard workload.
     *
     * @return boolean
     */
    public function add_standard_workload($data)
    {
        $affectedRows = 0;

        foreach ($data as $key => $value) {
            if ($value[0] != '' && $value[0] != null) {
                $this->db->where('id', $value[0]);
                $this->db->update(
                    db_prefix() . 'standard_workload',
                    [
                        'staffid' => $value[1],
                        'monday' => $value[2],
                        'tuesday' => $value[3],
                        'wednesday' => $value[4],
                        'thursday' => $value[5],
                        'friday' => $value[6],
                        'saturday' => $value[7],
                        'sunday' => $value[8],
                    ]
                );
                if ($this->db->affected_rows() > 0) {
                    $affectedRows++;
                }
            } else {
                $this->db->insert(db_prefix() . 'standard_workload', [
                    'staffid' => $value[1],
                    'monday' => $value[2],
                    'tuesday' => $value[3],
                    'wednesday' => $value[4],
                    'thursday' => $value[5],
                    'friday' => $value[6],
                    'saturday' => $value[7],
                    'sunday' => $value[8],
                ]);
                $insert_id = $this->db->insert_id();
                if ($insert_id) {
                    $affectedRows++;
                }
            }
        }
        if ($affectedRows > 0) {
            return true;
        }
        return false;
    }

    /**
     * delete standard workload
     *
     * @param int $id The identifier
     *
     * @return boolean
     */
    public function delete_standard_workload($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'standard_workload');
        if ($this->db->affected_rows() > 0) {
            return true;
        }

        return false;
    }

    /**
     * update general setting
     *
     * @param array $data The data
     *
     * @return boolean
     */
    public function update_setting($data)
    {
        $affectedRows = 0;
        if (!isset($data['staff_workload_monday'])) {
            $data['staff_workload_monday'] = 0;
        }
        if (!isset($data['staff_workload_tuesday'])) {
            $data['staff_workload_tuesday'] = 0;
        }
        if (!isset($data['staff_workload_thursday'])) {
            $data['staff_workload_thursday'] = 0;
        }
        if (!isset($data['staff_workload_wednesday'])) {
            $data['staff_workload_wednesday'] = 0;
        }
        if (!isset($data['staff_workload_friday'])) {
            $data['staff_workload_friday'] = 0;
        }
        if (!isset($data['staff_workload_saturday'])) {
            $data['staff_workload_saturday'] = 0;
        }
        if (!isset($data['staff_workload_sunday'])) {
            $data['staff_workload_sunday'] = 0;
        }
        foreach ($data as $key => $value) {
            $this->db->where('name', $key);
            $this->db->update(db_prefix() . 'options', [
                'value' => $value,
            ]);
            if ($this->db->affected_rows() > 0) {
                $affectedRows++;
            }
        }

        if ($affectedRows > 0) {
            return true;
        }
        return false;
    }

    /**
     * Gets the standard workload by staff.
     *
     * @param int $staffid The staffid
     *
     * @return float the standard workload by staff
     */
    public function get_standard_workload_by_staff($staffid, $date)
    {
        if (!$this->check_format_date($date)) {
            $date = to_sql_date($date);
        }

        $this->db->where('staffid', $staffid);
        $standard_workload = $this->db->get(db_prefix() . 'standard_workload')->row();

        if ($standard_workload) {
            $working_days = [];
            $working_days[1] = $standard_workload->monday;
            $working_days[2] = $standard_workload->tuesday;
            $working_days[3] = $standard_workload->wednesday;
            $working_days[4] = $standard_workload->thursday;
            $working_days[5] = $standard_workload->friday;
            $working_days[6] = $standard_workload->saturday;
            $working_days[7] = $standard_workload->sunday;

            return $working_days[date('N', strtotime($date))];
        } else {
            return get_option('standard_workload');
        }
    }

    /**
     * Gets the staff select.
     *
     * @return array the staff select
     */
    public function get_staff_select()
    {
        $staff = $this->staff_model->get('', ['active' => 1]);
        $list_staff = [];
        foreach ($staff as $key => $value) {
            $note = [];
            $note['id'] = $value['staffid'];
            $note['label'] = trim($value['firstname'].' '.$value['lastname']);
            $list_staff[] = $note;
        }
        return $list_staff;
    }

    /**
     * Gets the total standard workload.
     *
     * @param int  $staffid The staffid
     * @param Date $f_date  The f date
     * @param Date $t_date  The t date
     *
     * @return array the staff select
     */
    public function get_total_standard_workload($staffid, $f_date, $t_date)
    {
        $total = 0;
        while (strtotime($f_date) <= strtotime($t_date)) {
            if ($this->check_date_working($f_date)) {
                $standard_workload = $this->get_standard_workload_by_staff($staffid, $f_date);

                $total += $standard_workload;
            }

            $f_date = date('Y-m-d', strtotime('+1 day', strtotime($f_date)));
        }

        return $total;
    }

    /**
     * update task assigned
     *
     * @param object $data The data
     */
    public function update_task_assigned($data)
    {
        $this->db->where('taskid', $data['task_id']);
        $this->db->delete(db_prefix() . 'task_assigned');

        $this->db->insert(db_prefix() . 'task_assigned', [
            'taskid' => $data['task_id'],
            'staffid' => $data['staff_id'],
            'assigned_from' => get_staff_user_id(),
        ]);
    }
}
