<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Scoring_turnover_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Sources

    /**
     * Get leads sources
     * @param  mixed $id Optional - Source ID
     * @return mixed object if id passed else array
     */
    public function get_value($id = false)
    {
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            return $this->db->get(db_prefix() . 'turnovers')->row();
        }

        $this->db->order_by('value', 'asc');

        return $this->db->get(db_prefix() . 'turnovers')->result_array();
    }

    /**
     * Add new lead source
     * @param mixed $data source data
     */
    public function add_value($data)
    {
        $this->db->insert(db_prefix() . 'turnovers', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Turnover Added [SourceID: ' . $insert_id . ', Value: ' . $data['value'] . ']');
        }

        return $insert_id;
    }

    /**
     * Update lead source
     * @param  mixed   $data source data
     * @param  mixed   $id   source id
     * @return boolean
     */
    public function update_value($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'turnovers', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Turnover Updated [SourceID: ' . $id . ', Value: ' . $data['value'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Delete lead source from database
     * @param  mixed $id source id
     * @return mixed
     */
    public function delete_value($id)
    {
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'turnovers');
        if ($this->db->affected_rows() > 0) {
            log_activity('Turnover Deleted [SourceID: ' . $id . ']');

            return true;
        }

        return false;
    }
}
