<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Scoring_zones_model extends App_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Sources

    /**
     * Get leads sources
     * @param  mixed $id Optional - Source ID
     * @return mixed object if id passed else array
     */
    public function get_zone($id = false)
    {
        if (is_numeric($id)) {
            $this->db->where('id', $id);

            return $this->db->get(db_prefix() . 'zones')->row();
        }

        $this->db->order_by('name', 'asc');

        return $this->db->get(db_prefix() . 'zones')->result_array();
    }

    /**
     * Add new lead source
     * @param mixed $data source data
     */
    public function add_zone($data)
    {
        $this->db->insert(db_prefix() . 'zones', $data);
        $insert_id = $this->db->insert_id();
        if ($insert_id) {
            log_activity('New Zone Added [SourceID: ' . $insert_id . ', Name: ' . $data['name'] . ']');
        }

        return $insert_id;
    }

    /**
     * Update lead source
     * @param  mixed   $data source data
     * @param  mixed   $id   source id
     * @return boolean
     */
    public function update_zone($data, $id)
    {
        $this->db->where('id', $id);
        $this->db->update(db_prefix() . 'zones', $data);
        if ($this->db->affected_rows() > 0) {
            log_activity('Zone Updated [SourceID: ' . $id . ', Name: ' . $data['name'] . ']');

            return true;
        }

        return false;
    }

    /**
     * Delete lead source from database
     * @param  mixed $id source id
     * @return mixed
     */
    public function delete_zone($id)
    {
        $current = $this->get_zone($id);
        // Check if is already using in table
        if (is_reference_in_table('zone_id', db_prefix() . 'leads', $id) || is_reference_in_table('lead_source', db_prefix() . 'leads_email_integration', $id)) {
            return [
                'referenced' => true,
            ];
        }
        $this->db->where('id', $id);
        $this->db->delete(db_prefix() . 'zones');
        if ($this->db->affected_rows() > 0) {
            if (get_option('default_zone') == $id) {
                update_option('default_zone', '');
            }
            log_activity('Zone Deleted [SourceID: ' . $id . ']');

            return true;
        }

        return false;
    }
}
