<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Scoring Management
Description: Scoring management module.
Version: 1.0.0
Requires at least: 1.0.*
*/

define('SCORING_MODULE_NAME', 'scoring');

hooks()->add_action('admin_init', 'scoring_permissions');
hooks()->add_action('admin_init', 'scoring_module_init_menu_items');
hooks()->add_action('app_admin_footer', 'scoring_load_js');
hooks()->add_filter('other_merge_fields_available_for', 'scoring_register_other_merge_fields');
hooks()->add_action('lead_created_scoring', 'save_scoring_lead');


/**
 * Register activation module hook
 */
register_activation_hook(SCORING_MODULE_NAME, 'scoring_module_activation_hook');
/**
 * Load the module helper
 */
$CI = &get_instance();

function scoring_module_activation_hook()
{
    $CI = &get_instance();
    //require_once(__DIR__ . '/install.php');
}

/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(SCORING_MODULE_NAME, [SCORING_MODULE_NAME]);

$CI = &get_instance();
$CI->load->helper(SCORING_MODULE_NAME . '/scoring');
/**
 * Init mailbox module setting menu items in setup in admin_init hook
 *
 * @return null
 */
function scoring_module_init_menu_items()
{
    $CI = &get_instance();

    $CI->app_tabs->add_settings_tab('scoring', [
        'name'     => ''._l('app_tab_scoring__setting').'',
        'view'     => 'scoring/setting',
        'position' => 10,
    ]);

    $CI->app_tabs->add_settings_tab('serial_number', [
        'href'     => '#',
        'name'     => _l('app_tab_scoring__serial_number'),
        'view'     => 'scoring/serial_number',
        'position' => 1000,
        'icon'     => 'fas fa-calculator-alt',
    ]);

    /*$CI->app_menu->add_setup_menu_item('scoring', [
        'href'     => admin_url('scoring/sources'),
        'name'     => _l('scoring'),
        'position' => 67,
        'icon'     => 'fas fa-calculator-alt',
    ]);*/

    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'source',
            'name'     => _l('setup_menu_scoring__sources'),
            'href'     => admin_url('scoring/sources'),
            'position' => 1,
        ]
    );

    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'zone',
            'name'     => _l('setup_menu_scoring__zones'),
            'href'     => admin_url('scoring/zones'),
            'position' => 2,
        ]
    );

    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'designation',
            'name'     => _l('setup_menu_scoring__designations'),
            'href'     => admin_url('scoring/designations'),
            'position' => 3,
        ]
    );
    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'employee',
            'name'     => _l('setup_menu_scoring__employees'),
            'href'     => admin_url('scoring/number_employees'),
            'position' => 4,
        ]
    );
    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'turnover',
            'name'     => _l('setup_menu_scoring__turnovers'),
            'href'     => admin_url('scoring/turnovers'),
            'position' => 5,
        ]
    );
    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'industry',
            'name'     => _l('setup_menu_scoring__industries'),
            'href'     => admin_url('scoring/industries'),
            'position' => 6,
        ]
    );
    $CI->app_menu->add_setup_children_item(
        'scoring',
        [
            'slug'     => 'city',
            'name'     => _l('setup_menu_scoring__cities'),
            'href'     => admin_url('scoring/cities'),
            'position' => 7,
        ]
    );
}

function scoring_permissions()
{
    $capabilities = [];

    $capabilities['capabilities'] = [
        'view'   => _l('permission_view') . '(' . _l('permission_global') . ')',
        'create' => _l('permission_create'),
        'edit'   => _l('permission_edit'),
        'delete' => _l('permission_delete'),
    ];

    register_staff_capabilities('scoring', $capabilities, _l('scoring'));
}

/**
 * Injects chat Javascript
 * @return null
 */
function scoring_load_js()
{
    $CI = &get_instance();
    echo '<script src="'.module_dir_url('scoring', 'assets/js/scoring.js').'?v=' . $CI->app_scripts->core_version().'"></script>';
}
/**
 * Register other merge fields for appointly
 *
 * @param  [array] $for
 * @return void
 */
function scoring_register_other_merge_fields($for)
{
    $for[] = 'scoring';

    return $for;
}

/**
 * Register other merge fields for appointly
 *
 * @param  [array] $for
 * @return void
 */
function save_scoring_lead($lead_id)
{
    $for[] = 'scoring';

    return $for;
}
