<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
  <div class="breadcrumb">
    <a href="<?php echo admin_url(); ?>">Dashboard</a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php
    echo substr(current_url(), 38);
    ?>
  </div>
	<div class="admin-title">
		<h1><?= $this->config->item('icons')['scoring/zones']; ?> 
		<?php echo html_entity_decode($title); ?></h1>
	</div>

   <div class="content">
    <div class="row">
      <div class="col-md-12">
        <div class="card bd-0 shadow-base panel_s">
          <div class="card-body pd-15 panel-body">
            <ul class="nav nav-tabs profile-tabs row scoring-profile-tabs nav-tabs-horizontal">
            <li><a href="<?php echo admin_url(); ?>scoring/sources " class="nav-tabs-scoring">Surse</a></li>
            <li class="active"><a href="<?php echo admin_url(); ?>scoring/zones" class="nav-tabs-scoring">Zone</a></li>
            <li><a href="<?php echo admin_url(); ?>scoring/number_employees" class="nav-tabs-scoring">Nr. Angajati</a></li>
            <li><a href="<?php echo admin_url(); ?>scoring/designations" class="nav-tabs-scoring">Functie</a></li>
            <li><a href="<?php echo admin_url(); ?>scoring/turnovers" class="nav-tabs-scoring">Cifra de afaceri</a></li>
            <li><a href="<?php echo admin_url(); ?>scoring/industries" class="nav-tabs-scoring">Industrii</a></li>
            <li><a href="<?php echo admin_url(); ?>scoring/cities" class="nav-tabs-scoring">Orase</a>
            </ul>
            <a href="#" onclick="new_source(); return false;" class="btn btn-info"><?php echo _l('lead_new_zone'); ?></a>
          </div>
        </div>
        <div class=" bd-0 shadow-base mg-t-15 panel_s">
          <div class="pd-15 panel-body">
            <?php if (count($zones) > 0) { ?>
              <table class="table dt-table scroll-responsive" data-order-col="1" data-order-type="asc">
                <thead>
                <th><?php echo _l('id'); ?></th>
                <th><?php echo _l('zone'); ?></th>
                <th><?php echo _l('country'); ?></th>
                <th><?php echo _l('score'); ?></th>
                <th><?php echo _l('options'); ?></th>
                </thead>
                <tbody>
                <?php foreach ($zones as $zone) { ?>
                  <tr>
                    <td><?php echo $zone['id']; ?></td>
                    <td><a class="tx-medium tx-inverse tx-14" href="#" onclick="edit_source(this,<?php echo $zone['id']; ?>); return false"
                           data-name="<?php echo $zone['name']; ?>" data-score="<?php echo $zone['score']; ?>"><?php echo $zone['name']; ?></a><br />
                      <span class="text-muted">
                                        <?php echo _l('leads_table_total', total_rows(db_prefix() . 'leads', ['zone_id' => $zone['id']])); ?>
                                    </span>
                    </td>
                    <?php $country = get_country($zone['country_id'])?>
                    <td><?php echo $country ? $country->long_name : ''  ?></td>
                    <td><?php echo $zone['score']; ?></td>
                    <td>
                      <a href="#" onclick="edit_source(this,<?php echo $zone['id']; ?>); return false" data-name="<?php echo $zone['name']; ?>"
                         data-score="<?php echo $zone['score']; ?>" data-country_id="<?php echo $zone['country_id']; ?>"
                         class="btn btn-outline-secondary btn-sm btn-icon"><i class="fal fa-edit"></i></a>
                      <a href="<?php echo admin_url('scoring/delete_zone/' . $zone['id']); ?>" class="btn btn-danger btn-sm _delete btn-icon btn-icon"><i
                            class="fal fa-trash"></i></a>
                    </td>
                  </tr>
                <?php } ?>
                </tbody>
              </table>
            <?php } else { ?>
              <p class="mg-0"><?php echo _l('leads_sources_not_found'); ?></p>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
  </div>
  
</div>
<div class="modal fade" id="source" tabindex="-1" role="dialog">
  <div class="modal-dialog">
    <?php echo form_open(admin_url('scoring/zone')); ?>
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="tx-14 mg-b-0 tx-uppercase tx-inverse tx-bold">
          <span class="edit-title"><?php echo _l('edit_zone'); ?></span>
          <span class="add-title"><?php echo _l('new_zone'); ?></span>
        </h4>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-12">
            <div id="additional"></div>
            <div class="form-group">
              <?php echo render_input('name', 'zone_add_edit_name'); ?>
            </div>
            <div class="form-group">
              <?php echo render_input('score', 'Score', '', 'number'); ?>
            </div>
            <div class="form-group">
              <?php echo render_select('country_id', get_all_countries(), ['country_id' , 'long_name'], 'country', get_option('customer_default_country')); ?>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-outline-secondary" data-dismiss="modal"><?php echo _l('close'); ?></button>
        <button type="submit" class="btn btn-info"><?php echo _l('submit'); ?></button>
      </div>
    </div>
    <!-- /.modal-content -->
    <?php echo form_close(); ?>
  </div>
  <!-- /.modal-dialog -->
</div>
<!-- /.modal -->
<?php show_footer(); ?><?php init_tail(); ?>
<script>
  $(function () {
    appValidateForm($('form'), {name: 'required'}, manage_leads_sources);
    $('#source').on('hidden.bs.modal', function (event) {
      $('#additional').html('');
      $('#source input[name="name"]').val('');
      $('#source input[name="score"]').val('');
      $('#source select[name="country"]').selectpicker('val', '');
      $('.add-title').removeClass('hide');
      $('.edit-title').removeClass('hide');
    });
  });

  function manage_leads_sources(form) {
    var data = $(form).serialize();
    var url = form.action;
    $.post(url, data).done(function (response) {
      window.location.reload();
    });
    return false;
  }

  function new_source() {
    $('#source').modal('show');
    $('.edit-title').addClass('hide');
  }

  function edit_source(invoker, id) {
    var name = $(invoker).data('name'),
        score = $(invoker).data('score'),
        country_id = $(invoker).data('country_id');
    $('#additional').append(hidden_input('id', id));
    $('#source input[name="name"]').val(name);
    $('#source input[name="score"]').val(score);
    $('#source select[name="country_id"]').selectpicker('val', country_id);

    $('#source').modal('show');
    $('.add-title').addClass('hide');
  }
</script>
</body>
</html>
