<?php

defined('BASEPATH') or exit('No direct script access allowed');

$aColumns = [
    'id','name','price','currency',
];

$sIndexColumn = 'id';
$sTable       = db_prefix() . 'invoice_products';

$filter = [];
$where  = [];

$join = [];

$result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
    'client_id',
    'customer_group',
    'description',
    db_prefix() . 'invoice_products.group as groupid',
]);

$output  = $result['output'];
$rResult = $result['rResult'];

foreach ($rResult as $aRow) {
    $aRow['price'] = is_numeric($aRow['price']) ? $aRow['price'] : 0 ;
    $currency = get_currency($aRow['currency']);
    $price = app_format_money($aRow['price'], $currency);

    $options = '<div class="row-options">';
    if (has_permission('invoices', '', 'edit')) {
        $options .= '<a href="' . admin_url('services/products/create/invoice/' . $aRow['id']) . '">' . _l('edit') . '</a>';
    }
    if (has_permission('invoices', '', 'delete')) {
        $options .= ' | <a class=" text-danger" href="' . admin_url('services/products/delete/invoice/' . $aRow['id']) . '">' . _l('delete') . '</a>';
    }
    $options .= '</div>';

    $for = '';
    if ($aRow['client_id']) {
        $client = get_client($aRow['client_id']);
        $contact_name = get_contact_full_name(get_primary_contact_user_id($aRow['client_id']));
        $name = (!is_empty_customer_company($aRow['client_id'])) ? $client->company : $contact_name ;
        $for .= "<a href='".admin_url('clients/client/'.$aRow['client_id'])."'>{$name}</a>";
    } elseif ($aRow['customer_group']) {
        $name = get_group_name($aRow['customer_group']);
        $for .= "<a href='".admin_url('clients')."'>{$name->name} group</a>";
    } else {
        $for = _l('customers');
    }

    $link = get_product_url($aRow['id'], $aRow['name'], 'invoice');
    $group = $aRow['groupid'] ? services_get_product_group_name($aRow['groupid'])->name : '';

    $row = [];
    $row[] = $aRow['id'] . $options;
    $row[] = $aRow['name'];
    $row[] = $price;
    $row[] = $for;
    $row[] = $group;
    $row[] = clear_textarea_breaks($aRow['description']);
    $row[] = '<a href="'.$link.'" target="_blank">' . $link . '</a>';
    $row['DT_RowClass'] = 'has-row-options';
    $output['aaData'][] = $row;
}
