<?php

defined('BASEPATH') or exit('No direct script access allowed');

/*
Module Name: Package - Startup
Description: Default module to apply changes to the menus
Version: 1.0.0
*/

define('PACKAGE_STARTUP', 'startup_package');

$CI = &get_instance();

/**
 * Register activation module hook
 */
register_activation_hook(PACKAGE_STARTUP, 'startup_activation_hook');
register_deactivation_hook(PACKAGE_STARTUP, 'startup_deactivation_hook');

hooks()->add_action('app_init', 'startup_init_package');
hooks()->add_action('admin_init', 'startup_init_menu_items');
hooks()->add_action('admin_init', 'startup_set_package');
hooks()->add_action('clients_init', 'startup_init_clients');


function startup_activation_hook()
{
    require_once(__DIR__ . '/activate.php');
}
function startup_deactivation_hook()
{
  require(__DIR__ . '/deactivate.php');
}


/**
 * Register language files, must be registered if the module is using languages
 */
register_language_files(PACKAGE_STARTUP, [PACKAGE_STARTUP]);

function startup_init_package(){
  $CI = &get_instance();
  $CI->app_acl->activate_staff();
  $CI->app_acl->activate_messages();
  $CI->app_acl->custom_fields();
  $CI->app_acl->technical_support();
  $CI->app_acl->finance();
  $CI->app_acl->reports();
  $CI->app_acl->legal();
  $CI->app_acl->activate_contracts();
  //$CI->app_acl->remove_disabled_route();
  //Pro
  $CI->app_acl->disabled_routes[] = 'admin/reports/expenses';
  $CI->app_acl->disabled_routes[] = 'admin/reports/expenses_vs_income';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/ceo';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/cmo';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/inbound_lead_generation';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/helpdesk';
  $CI->app_acl->disabled_routes[] = 'admin/dashboard/tactical_finance';
  //deactivate PayU|Stripe|Instamoj

  //Essential
  //Mobilpay|EuPlatesc|Stripe|2Checkout
  //Portal Clienti | Parteneri | Vendori

  //Preluare Leaduri Formular | Email
  $CI->app_acl->disabled_routes[] = 'admin/leads/forms';
  $CI->app_acl->disabled_routes[] = 'admin/leads/form';
  $CI->app_acl->disabled_routes[] = 'wtl/index';

  //Management Leaduri

  //Remarketing Facebook|Instagram

  //Pipeline Vanzari

  //Management Oportunitati

  //Ofertari Dinamice

  //Estimari Cost Dinamice

  //Propuneri Dinamice

  //Management Contracte

  //Management Proiecte

  //Management Taskuri

  //Calendar Google|Microsoft

  //Chat Intern Individual|Grupuri

  //Istoric Actiuni Utilizatori

  //Facturare EDI via EDIconnect

  //Dezactivare Mobilpay|EuPlatesc|Stripe|2Checkout

  //Evidenta Cheltuieli

  //Resurse Umane|Pontaj|Concedii -> dezactiv modul, ramane HR


  //Sistem Evaluare Angajati

  //Gestiune Obiecte Inventar -> warehouse dezactivat

  //Monitorizare servere, site-uri, IPuri -> Monitor? Token delete / deactivate

  //Suport integrari ecommerce -> nu avem, block API

  //limit 0Gb pe utilities media

  //$CI->app_acl->do_blocked_routes();
}

function startup_init_clients(){
  startup_init_menu_items();
}
/**
 * Init menu setup module menu items in setup in admin_init hook
 * @return null
 */
function startup_init_menu_items()
{
    $CI = &get_instance();
    if (is_admin()) {


    }


}

function startup_set_package(){
  $CI = &get_instance();

  hooks()->do_action('package_loaded');
}


// return status book
if(!DEFINED('MEMBERS_INCLUDED')){
DEFINE('MEMBERS_INCLUDED',3);
}
hooks()->add_filter('before_staff_status_change', 'str_max_members', 10, 2);
function str_max_members($status, $id){
  $CI = &get_instance();

  $max_active_members = MEMBERS_INCLUDED + (int)get_option('extra_seats');
  if((int)$status == 1){
    if((int)$CI->staff_model->count_active_members() >= $max_active_members AND $max_active_members != 0){
      return 0;
    }else{
      return 1;
    }
  }else{
    return 0;
  }


}
