<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Participate extends ClientsController
{
    public function index($id, $hash)
    {
        $this->load->model('surveys_model');
        $survey = $this->surveys_model->get($id);
        // Last statement is for
        if (!$survey
            || ($survey->hash != $hash)
            || (!$hash || !$id)
            // Users with permission manage surveys to preview the survey even if is not active
            || ($survey->active == 0 && !has_permission('surveys', '', 'view'))
             // Check if survey is only for logged in participants / staff / clients
            || ($survey->onlyforloggedin == 1 && !is_logged_in())
        ) {
            show_404();
        }

        // Ip Restrict Check
        if ($survey->iprestrict == 1) {
            $this->db->where('surveyid', $id);
            $this->db->where('ip', $this->input->ip_address());
            $total = $this->db->count_all_results(db_prefix().'surveyresultsets');
            if ($total > 0) {
                show_404();
            }
        }
        if ($this->input->post()) {
            $this->form_validation->set_rules('forms', 'forms', 'required');
            foreach($survey->questions as $question){

              if($question['required'] == '1' and $question['boxtype'] != 'checkbox' and $question['boxtype'] != 'radio' and $question['boxtype'] != 'rating'){
                $this->form_validation->set_rules('question['.$question['questionid'].'][]', $question['question'], 'required');
              }
              if($question['required'] == '1' and ( $question['boxtype'] == 'checkbox' OR $question['boxtype'] == 'radio' OR $question['boxtype'] == 'rating')){
                $this->form_validation->set_rules('selectable[' . $question['boxid'] . ']['.$question['questionid'].'][]', $question['question'], 'required');
              }

            }

            if ($this->form_validation->run() !== FALSE){
                $success = $this->surveys_model->add_survey_result($id, $this->input->post());
                if ($success) {
                    $survey = $this->surveys_model->get($id);
                    if ($survey->redirect_url != '') {
                        redirect(fix_url($survey->redirect_url),'refresh');
                    }
                    // Message is by default in English because there is no easy way to know the customer language
                    set_alert('success', hooks()->apply_filters('survey_success_message', 'Thank you for participating in this survey. Your answers are very important to us.'));

                    redirect(hooks()->apply_filters('survey_default_redirect', site_url('survey/' . $id . '/' . $hash . '?participated=yes')));
                }
              }else{
                  echo validation_errors();
              }



        }

        $this->app_css->theme('surveys-css', module_dir_url('surveys', 'assets/css/surveys.css'));

        $this->disableNavigation()
        ->disableSubMenu();

        $this->data(['survey'=>$survey]);
        $this->title($survey->subject);
        no_index_customers_area();
        $this->view('participate');
        $this->layout();
    }
}
