<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>

<div id="wrapper">
  <div class="breadcrumb">
  <a href="<?php echo admin_url(); ?>">Dashboard</a>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;<?php echo html_entity_decode($title); ?>
  </div>
	<div class="admin-title">
		<h1><?= $this->config->item('icons')['whatsapp_chat']; ?>
		<?php echo html_entity_decode($title); ?></h1>
	</div>
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <a href="#" onclick="save_whatsapp_chat(); return false;" class="btn btn-info"><?= _l('save_changes'); ?></a>
                        <a href="#" onclick="enable_whatsapp_chat(); return false;" class="btn btn-info" <?php if (get_option('whatsapp_chat') == 'enable') {
    echo 'disabled';
}?>><?= _l('enable'); ?> <?= _l('whatsapp_chat_support'); ?></a>
                        <a href="#" onclick="disable_whatsapp_chat(); return false;" class="btn btn-info" <?php if (get_option('whatsapp_chat') == 'disable') {
    echo 'disabled';
}?>><?= _l('disable'); ?> <?= _l('whatsapp_chat_support'); ?></a>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4><?= _l('whatsapp_chat_config_title'); ?></h4>
                        <h5><?= _l('whatsapp_chat_config_info'); ?></h6>
                        <br>
                        <br>
                        <div class="form-group">
                            <label class="bold" for="whatsapp_chat_clients_and_admin_area"><?= _l('whatsapp_chat_clients_and_admin_area'); ?> <i class="fa fa-question-circle" data-toggle="tooltip" data-title="<?= _l('whatsapp_tooltip_1');?>"></i></label>
                            <br><input type="text" name="whatsapp_chat_clients_and_admin_area" id="whatsapp_chat_clients_and_admin_area" class="form-control" value="<?php echo clear_textarea_breaks(get_option('whatsapp_chat_clients_and_admin_area')); ?>">
                        </div>
                        <div class="form-group">
                            <label class="bold" for="whatsapp_chat_admin_area"><?= _l('whatsapp_chat_admin_area'); ?> <i class="fa fa-question-circle" data-toggle="tooltip" data-title="<?= _l('whatsapp_tooltip_2');?>"></i></label>
                            <input type="text" name="whatsapp_chat_admin_area" id="whatsapp_chat_admin_area" class="form-control" value="<?php echo clear_textarea_breaks(get_option('whatsapp_chat_admin_area')); ?>">
                        </div>
                        <div class="form-group">
                            <label class="bold" for="whatsapp_chat_clients_area"><?= _l('whatsapp_chat_clients_area'); ?> <i class="fa fa-question-circle" data-toggle="tooltip" data-title="<?= _l('whatsapp_tooltip_3');?>"></i></label>
                            <input type="text" name="whatsapp_chat_clients_area" id="whatsapp_chat_clients_area" class="form-control" value="<?php echo clear_textarea_breaks(get_option('whatsapp_chat_clients_area')); ?>">
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
<?php show_footer(); ?><?php init_tail(); ?>

<script>
   $(function() {
   });

   function save_whatsapp_chat() {
       $.post(admin_url + 'whatsapp_chat/save', {
            admin_area: $('#whatsapp_chat_admin_area').val(),
            clients_area: $('#whatsapp_chat_clients_area').val(),
            clients_and_admin: $('#whatsapp_chat_clients_and_admin_area').val(),
       }).done(function(response) {
            window.location = admin_url+'whatsapp_chat';
       });
   }

   function enable_whatsapp_chat() {
       $.post(admin_url + 'whatsapp_chat/enable', {
       }).done(function() {
            window.location = admin_url+'whatsapp_chat';
       });
   }

   function disable_whatsapp_chat() {
       $.post(admin_url + 'whatsapp_chat/disable', {
       }).done(function() {
            window.location = admin_url+'whatsapp_chat';
       });
   }
</script>

</body>
</html>
