<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\TwiML\Voice;

use Twilio\TwiML\TwiML;

class Enqueue extends TwiML {
    /**
     * Enqueue constructor.
     * 
     * @param string $name Friendly name
     * @param array $attributes Optional attributes
     */
    public function __construct($name = null, $attributes = array()) {
        parent::__construct('Enqueue', $name, $attributes);
    }

    /**
     * Add Task child.
     * 
     * @param string $body TaskRouter task attributes
     * @return TwiML Child element.
     */
    public function task($body) {
        return $this->nest(new Voice\Task($body));
    }

    /**
     * Add Action attribute.
     * 
     * @param url $action Action URL
     * @return TwiML $this.
     */
    public function setAction($action) {
        return $this->setAttribute('action', $action);
    }

    /**
     * Add Method attribute.
     * 
     * @param httpMethod $method Action URL method
     * @return TwiML $this.
     */
    public function setMethod($method) {
        return $this->setAttribute('method', $method);
    }

    /**
     * Add WaitUrl attribute.
     * 
     * @param url $waitUrl Wait URL
     * @return TwiML $this.
     */
    public function setWaitUrl($waitUrl) {
        return $this->setAttribute('waitUrl', $waitUrl);
    }

    /**
     * Add WaitUrlMethod attribute.
     * 
     * @param httpMethod $waitUrlMethod Wait URL method
     * @return TwiML $this.
     */
    public function setWaitUrlMethod($waitUrlMethod) {
        return $this->setAttribute('waitUrlMethod', $waitUrlMethod);
    }

    /**
     * Add WorkflowSid attribute.
     * 
     * @param string $workflowSid TaskRouter Workflow SID
     * @return TwiML $this.
     */
    public function setWorkflowSid($workflowSid) {
        return $this->setAttribute('workflowSid', $workflowSid);
    }
}