#!/bin/bash

# Sleep random time before starting. Avoid running all bkp scripts at the same time
#sleep $(shuf -i 0-1800 -n 1)

# Set the backup directory and file name
BACKUP_DIR=/backup
DATE=`date +%Y-%m-%d-%H-%M-%S`
CRM_BKP_DIR=$BACKUP_DIR/crm-${POD_NAMESPACE}/${DATE}

mkdir -p $CRM_BKP_DIR

# Set the MySQL credentials
MYSQL_USER=${APP_DB_USERNAME}
MYSQL_ROOT_PASSWORD=${APP_DB_PASSWORD}
MYSQL_HOST="${APP_DB_HOSTNAME}"


# Get a list of all databases
DATABASES="mysql crmcon"

# Loop through the list of databases and back them up one by one
for db in $DATABASES; do
  echo "Backing up database: $db"
  mysqldump -u$MYSQL_USER -h$MYSQL_HOST -p$MYSQL_ROOT_PASSWORD --databases $db > $CRM_BKP_DIR/$db.sql
  gzip $CRM_BKP_DIR/$db.sql
done

tar -czf $CRM_BKP_DIR/uploads.tar.gz /uploads
tar -czf $CRM_BKP_DIR/sessions.tar.gz /sessions

rclone --config /root/rclone/rclone.conf copy /backup/ eu2:/azure-crm-backup/

rm -rf /backup/*
