#!/bin/bash

set -e

role=${CONTAINER_ROLE:-app}

rm -rf /etc/default/locale
env >> /etc/default/locale


if [ "$role" = "app" ]; then

    echo "D C A  A P P L I C A T I O N  C O N T A I N E R"
    echo "Starting cron"
    service cron start
    echo "Starting apache ..."

    rm -rf /var/www/html/install
    apache2-foreground

    exec "$@"

elif [ "$role" = "migrator" ]; then

    echo "D C A  M I G R A T O R C O N T A I N E R"

    exec "$@"


else
    echo "Could not match the container role \"$role\""
    exit 1
fi